/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.companies.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.UpdateCompanyRequestBody;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = UpdateCompanyRequest.Builder.class)
public final class UpdateCompanyRequest {
    private final String companyId;

    private final Optional<UpdateCompanyRequestBody> body;

    private final Map<String, Object> additionalProperties;

    private UpdateCompanyRequest(
            String companyId, Optional<UpdateCompanyRequestBody> body, Map<String, Object> additionalProperties) {
        this.companyId = companyId;
        this.body = body;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The unique identifier for the company which is given by Intercom
     */
    @JsonProperty("company_id")
    public String getCompanyId() {
        return companyId;
    }

    @JsonProperty("body")
    public Optional<UpdateCompanyRequestBody> getBody() {
        return body;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof UpdateCompanyRequest && equalTo((UpdateCompanyRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateCompanyRequest other) {
        return companyId.equals(other.companyId) && body.equals(other.body);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.companyId, this.body);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CompanyIdStage builder() {
        return new Builder();
    }

    public interface CompanyIdStage {
        /**
         * <p>The unique identifier for the company which is given by Intercom</p>
         */
        _FinalStage companyId(@NotNull String companyId);

        Builder from(UpdateCompanyRequest other);
    }

    public interface _FinalStage {
        UpdateCompanyRequest build();

        _FinalStage body(Optional<UpdateCompanyRequestBody> body);

        _FinalStage body(UpdateCompanyRequestBody body);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements CompanyIdStage, _FinalStage {
        private String companyId;

        private Optional<UpdateCompanyRequestBody> body = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(UpdateCompanyRequest other) {
            companyId(other.getCompanyId());
            body(other.getBody());
            return this;
        }

        /**
         * <p>The unique identifier for the company which is given by Intercom</p>
         * <p>The unique identifier for the company which is given by Intercom</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("company_id")
        public _FinalStage companyId(@NotNull String companyId) {
            this.companyId = Objects.requireNonNull(companyId, "companyId must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage body(UpdateCompanyRequestBody body) {
            this.body = Optional.ofNullable(body);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "body", nulls = Nulls.SKIP)
        public _FinalStage body(Optional<UpdateCompanyRequestBody> body) {
            this.body = body;
            return this;
        }

        @java.lang.Override
        public UpdateCompanyRequest build() {
            return new UpdateCompanyRequest(companyId, body, additionalProperties);
        }
    }
}
