/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.companies.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.JsonValue;
import com.intercom.api.types.CompanyList;
import java.util.Objects;
import java.util.Optional;

public final class CompaniesRetrieveResponse {
    private final Value value;

    @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
    private CompaniesRetrieveResponse(Value value) {
        this.value = value;
    }

    public <T> T visit(Visitor<T> visitor) {
        return value.visit(visitor);
    }

    public static CompaniesRetrieveResponse company(Company value) {
        return new CompaniesRetrieveResponse(new CompanyValue(value));
    }

    public static CompaniesRetrieveResponse list(CompanyList value) {
        return new CompaniesRetrieveResponse(new ListValue(value));
    }

    public boolean isCompany() {
        return value instanceof CompanyValue;
    }

    public boolean isList() {
        return value instanceof ListValue;
    }

    public boolean _isUnknown() {
        return value instanceof _UnknownValue;
    }

    public Optional<Company> getCompany() {
        if (isCompany()) {
            return Optional.of(((CompanyValue) value).value);
        }
        return Optional.empty();
    }

    public Optional<CompanyList> getList() {
        if (isList()) {
            return Optional.of(((ListValue) value).value);
        }
        return Optional.empty();
    }

    public Optional<Object> _getUnknown() {
        if (_isUnknown()) {
            return Optional.of(((_UnknownValue) value).value);
        }
        return Optional.empty();
    }

    @JsonValue
    private Value getValue() {
        return this.value;
    }

    public interface Visitor<T> {
        T visitCompany(Company company);

        T visitList(CompanyList list);

        T _visitUnknown(Object unknownType);
    }

    @JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "type", visible = true, defaultImpl = _UnknownValue.class)
    @JsonSubTypes({@JsonSubTypes.Type(CompanyValue.class), @JsonSubTypes.Type(ListValue.class)})
    @JsonIgnoreProperties(ignoreUnknown = true)
    private interface Value {
        <T> T visit(Visitor<T> visitor);
    }

    @JsonTypeName("company")
    @JsonIgnoreProperties("type")
    private static final class CompanyValue implements Value {
        @JsonUnwrapped
        private Company value;

        @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
        private CompanyValue() {}

        private CompanyValue(Company value) {
            this.value = value;
        }

        @java.lang.Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitCompany(value);
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof CompanyValue && equalTo((CompanyValue) other);
        }

        private boolean equalTo(CompanyValue other) {
            return value.equals(other.value);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.value);
        }

        @java.lang.Override
        public String toString() {
            return "CompaniesRetrieveResponse{" + "value: " + value + "}";
        }
    }

    @JsonTypeName("list")
    @JsonIgnoreProperties("type")
    private static final class ListValue implements Value {
        @JsonUnwrapped
        private CompanyList value;

        @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
        private ListValue() {}

        private ListValue(CompanyList value) {
            this.value = value;
        }

        @java.lang.Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitList(value);
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof ListValue && equalTo((ListValue) other);
        }

        private boolean equalTo(ListValue other) {
            return value.equals(other.value);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.value);
        }

        @java.lang.Override
        public String toString() {
            return "CompaniesRetrieveResponse{" + "value: " + value + "}";
        }
    }

    @JsonIgnoreProperties("type")
    private static final class _UnknownValue implements Value {
        private String type;

        @JsonValue
        private Object value;

        @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
        private _UnknownValue(@JsonProperty("value") Object value) {}

        @java.lang.Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor._visitUnknown(value);
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof _UnknownValue && equalTo((_UnknownValue) other);
        }

        private boolean equalTo(_UnknownValue other) {
            return type.equals(other.type) && value.equals(other.value);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.type, this.value);
        }

        @java.lang.Override
        public String toString() {
            return "CompaniesRetrieveResponse{" + "type: " + type + ", value: " + value + "}";
        }
    }
}
