/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.customobjectinstances.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = DeleteCustomObjectInstancesByExternalIdRequest.Builder.class)
public final class DeleteCustomObjectInstancesByExternalIdRequest {
    private final String customObjectTypeIdentifier;

    private final String customObjectInstanceId;

    private final Map<String, Object> additionalProperties;

    private DeleteCustomObjectInstancesByExternalIdRequest(
            String customObjectTypeIdentifier,
            String customObjectInstanceId,
            Map<String, Object> additionalProperties) {
        this.customObjectTypeIdentifier = customObjectTypeIdentifier;
        this.customObjectInstanceId = customObjectInstanceId;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The unique identifier of the custom object type that defines the structure of the custom object instance.
     */
    @JsonProperty("custom_object_type_identifier")
    public String getCustomObjectTypeIdentifier() {
        return customObjectTypeIdentifier;
    }

    /**
     * @return The Intercom defined id of the custom object instance
     */
    @JsonProperty("custom_object_instance_id")
    public String getCustomObjectInstanceId() {
        return customObjectInstanceId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof DeleteCustomObjectInstancesByExternalIdRequest
                && equalTo((DeleteCustomObjectInstancesByExternalIdRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DeleteCustomObjectInstancesByExternalIdRequest other) {
        return customObjectTypeIdentifier.equals(other.customObjectTypeIdentifier)
                && customObjectInstanceId.equals(other.customObjectInstanceId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.customObjectTypeIdentifier, this.customObjectInstanceId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CustomObjectTypeIdentifierStage builder() {
        return new Builder();
    }

    public interface CustomObjectTypeIdentifierStage {
        /**
         * <p>The unique identifier of the custom object type that defines the structure of the custom object instance.</p>
         */
        CustomObjectInstanceIdStage customObjectTypeIdentifier(@NotNull String customObjectTypeIdentifier);

        Builder from(DeleteCustomObjectInstancesByExternalIdRequest other);
    }

    public interface CustomObjectInstanceIdStage {
        /**
         * <p>The Intercom defined id of the custom object instance</p>
         */
        _FinalStage customObjectInstanceId(@NotNull String customObjectInstanceId);
    }

    public interface _FinalStage {
        DeleteCustomObjectInstancesByExternalIdRequest build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements CustomObjectTypeIdentifierStage, CustomObjectInstanceIdStage, _FinalStage {
        private String customObjectTypeIdentifier;

        private String customObjectInstanceId;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(DeleteCustomObjectInstancesByExternalIdRequest other) {
            customObjectTypeIdentifier(other.getCustomObjectTypeIdentifier());
            customObjectInstanceId(other.getCustomObjectInstanceId());
            return this;
        }

        /**
         * <p>The unique identifier of the custom object type that defines the structure of the custom object instance.</p>
         * <p>The unique identifier of the custom object type that defines the structure of the custom object instance.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("custom_object_type_identifier")
        public CustomObjectInstanceIdStage customObjectTypeIdentifier(@NotNull String customObjectTypeIdentifier) {
            this.customObjectTypeIdentifier =
                    Objects.requireNonNull(customObjectTypeIdentifier, "customObjectTypeIdentifier must not be null");
            return this;
        }

        /**
         * <p>The Intercom defined id of the custom object instance</p>
         * <p>The Intercom defined id of the custom object instance</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("custom_object_instance_id")
        public _FinalStage customObjectInstanceId(@NotNull String customObjectInstanceId) {
            this.customObjectInstanceId =
                    Objects.requireNonNull(customObjectInstanceId, "customObjectInstanceId must not be null");
            return this;
        }

        @java.lang.Override
        public DeleteCustomObjectInstancesByExternalIdRequest build() {
            return new DeleteCustomObjectInstancesByExternalIdRequest(
                    customObjectTypeIdentifier, customObjectInstanceId, additionalProperties);
        }
    }
}
