/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.dataattributes.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.UpdateDataAttributeRequestBody;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = UpdateDataAttributeRequest.Builder.class)
public final class UpdateDataAttributeRequest {
    private final int dataAttributeId;

    private final UpdateDataAttributeRequestBody body;

    private final Map<String, Object> additionalProperties;

    private UpdateDataAttributeRequest(
            int dataAttributeId, UpdateDataAttributeRequestBody body, Map<String, Object> additionalProperties) {
        this.dataAttributeId = dataAttributeId;
        this.body = body;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The data attribute id
     */
    @JsonProperty("data_attribute_id")
    public int getDataAttributeId() {
        return dataAttributeId;
    }

    @JsonProperty("body")
    public UpdateDataAttributeRequestBody getBody() {
        return body;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof UpdateDataAttributeRequest && equalTo((UpdateDataAttributeRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateDataAttributeRequest other) {
        return dataAttributeId == other.dataAttributeId && body.equals(other.body);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.dataAttributeId, this.body);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static DataAttributeIdStage builder() {
        return new Builder();
    }

    public interface DataAttributeIdStage {
        /**
         * <p>The data attribute id</p>
         */
        BodyStage dataAttributeId(int dataAttributeId);

        Builder from(UpdateDataAttributeRequest other);
    }

    public interface BodyStage {
        _FinalStage body(@NotNull UpdateDataAttributeRequestBody body);
    }

    public interface _FinalStage {
        UpdateDataAttributeRequest build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements DataAttributeIdStage, BodyStage, _FinalStage {
        private int dataAttributeId;

        private UpdateDataAttributeRequestBody body;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(UpdateDataAttributeRequest other) {
            dataAttributeId(other.getDataAttributeId());
            body(other.getBody());
            return this;
        }

        /**
         * <p>The data attribute id</p>
         * <p>The data attribute id</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("data_attribute_id")
        public BodyStage dataAttributeId(int dataAttributeId) {
            this.dataAttributeId = dataAttributeId;
            return this;
        }

        @java.lang.Override
        @JsonSetter("body")
        public _FinalStage body(@NotNull UpdateDataAttributeRequestBody body) {
            this.body = Objects.requireNonNull(body, "body must not be null");
            return this;
        }

        @java.lang.Override
        public UpdateDataAttributeRequest build() {
            return new UpdateDataAttributeRequest(dataAttributeId, body, additionalProperties);
        }
    }
}
