/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.dataexport.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ExportReportingDataRequest.Builder.class)
public final class ExportReportingDataRequest {
    private final String jobIdentifier;

    private final String appId;

    private final String clientId;

    private final Map<String, Object> additionalProperties;

    private ExportReportingDataRequest(
            String jobIdentifier, String appId, String clientId, Map<String, Object> additionalProperties) {
        this.jobIdentifier = jobIdentifier;
        this.appId = appId;
        this.clientId = clientId;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Unique identifier of the job.
     */
    @JsonProperty("job_identifier")
    public String getJobIdentifier() {
        return jobIdentifier;
    }

    /**
     * @return The Intercom defined code of the workspace the company is associated to.
     */
    @JsonProperty("app_id")
    public String getAppId() {
        return appId;
    }

    @JsonProperty("client_id")
    public String getClientId() {
        return clientId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ExportReportingDataRequest && equalTo((ExportReportingDataRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ExportReportingDataRequest other) {
        return jobIdentifier.equals(other.jobIdentifier)
                && appId.equals(other.appId)
                && clientId.equals(other.clientId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.jobIdentifier, this.appId, this.clientId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static JobIdentifierStage builder() {
        return new Builder();
    }

    public interface JobIdentifierStage {
        /**
         * <p>Unique identifier of the job.</p>
         */
        AppIdStage jobIdentifier(@NotNull String jobIdentifier);

        Builder from(ExportReportingDataRequest other);
    }

    public interface AppIdStage {
        /**
         * <p>The Intercom defined code of the workspace the company is associated to.</p>
         */
        ClientIdStage appId(@NotNull String appId);
    }

    public interface ClientIdStage {
        _FinalStage clientId(@NotNull String clientId);
    }

    public interface _FinalStage {
        ExportReportingDataRequest build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements JobIdentifierStage, AppIdStage, ClientIdStage, _FinalStage {
        private String jobIdentifier;

        private String appId;

        private String clientId;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ExportReportingDataRequest other) {
            jobIdentifier(other.getJobIdentifier());
            appId(other.getAppId());
            clientId(other.getClientId());
            return this;
        }

        /**
         * <p>Unique identifier of the job.</p>
         * <p>Unique identifier of the job.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("job_identifier")
        public AppIdStage jobIdentifier(@NotNull String jobIdentifier) {
            this.jobIdentifier = Objects.requireNonNull(jobIdentifier, "jobIdentifier must not be null");
            return this;
        }

        /**
         * <p>The Intercom defined code of the workspace the company is associated to.</p>
         * <p>The Intercom defined code of the workspace the company is associated to.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("app_id")
        public ClientIdStage appId(@NotNull String appId) {
            this.appId = Objects.requireNonNull(appId, "appId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("client_id")
        public _FinalStage clientId(@NotNull String clientId) {
            this.clientId = Objects.requireNonNull(clientId, "clientId must not be null");
            return this;
        }

        @java.lang.Override
        public ExportReportingDataRequest build() {
            return new ExportReportingDataRequest(jobIdentifier, appId, clientId, additionalProperties);
        }
    }
}
