/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.dataexport.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = DataExportExportReportingDataResponse.Builder.class)
public final class DataExportExportReportingDataResponse {
    private final Optional<String> jobIdentifier;

    private final Optional<String> status;

    private final Optional<String> downloadUrl;

    private final Optional<String> downloadExpiresAt;

    private final Map<String, Object> additionalProperties;

    private DataExportExportReportingDataResponse(
            Optional<String> jobIdentifier,
            Optional<String> status,
            Optional<String> downloadUrl,
            Optional<String> downloadExpiresAt,
            Map<String, Object> additionalProperties) {
        this.jobIdentifier = jobIdentifier;
        this.status = status;
        this.downloadUrl = downloadUrl;
        this.downloadExpiresAt = downloadExpiresAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("job_identifier")
    public Optional<String> getJobIdentifier() {
        return jobIdentifier;
    }

    @JsonProperty("status")
    public Optional<String> getStatus() {
        return status;
    }

    @JsonProperty("download_url")
    public Optional<String> getDownloadUrl() {
        return downloadUrl;
    }

    @JsonProperty("download_expires_at")
    public Optional<String> getDownloadExpiresAt() {
        return downloadExpiresAt;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof DataExportExportReportingDataResponse
                && equalTo((DataExportExportReportingDataResponse) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DataExportExportReportingDataResponse other) {
        return jobIdentifier.equals(other.jobIdentifier)
                && status.equals(other.status)
                && downloadUrl.equals(other.downloadUrl)
                && downloadExpiresAt.equals(other.downloadExpiresAt);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.jobIdentifier, this.status, this.downloadUrl, this.downloadExpiresAt);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> jobIdentifier = Optional.empty();

        private Optional<String> status = Optional.empty();

        private Optional<String> downloadUrl = Optional.empty();

        private Optional<String> downloadExpiresAt = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(DataExportExportReportingDataResponse other) {
            jobIdentifier(other.getJobIdentifier());
            status(other.getStatus());
            downloadUrl(other.getDownloadUrl());
            downloadExpiresAt(other.getDownloadExpiresAt());
            return this;
        }

        @JsonSetter(value = "job_identifier", nulls = Nulls.SKIP)
        public Builder jobIdentifier(Optional<String> jobIdentifier) {
            this.jobIdentifier = jobIdentifier;
            return this;
        }

        public Builder jobIdentifier(String jobIdentifier) {
            this.jobIdentifier = Optional.ofNullable(jobIdentifier);
            return this;
        }

        @JsonSetter(value = "status", nulls = Nulls.SKIP)
        public Builder status(Optional<String> status) {
            this.status = status;
            return this;
        }

        public Builder status(String status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @JsonSetter(value = "download_url", nulls = Nulls.SKIP)
        public Builder downloadUrl(Optional<String> downloadUrl) {
            this.downloadUrl = downloadUrl;
            return this;
        }

        public Builder downloadUrl(String downloadUrl) {
            this.downloadUrl = Optional.ofNullable(downloadUrl);
            return this;
        }

        @JsonSetter(value = "download_expires_at", nulls = Nulls.SKIP)
        public Builder downloadExpiresAt(Optional<String> downloadExpiresAt) {
            this.downloadExpiresAt = downloadExpiresAt;
            return this;
        }

        public Builder downloadExpiresAt(String downloadExpiresAt) {
            this.downloadExpiresAt = Optional.ofNullable(downloadExpiresAt);
            return this;
        }

        public DataExportExportReportingDataResponse build() {
            return new DataExportExportReportingDataResponse(
                    jobIdentifier, status, downloadUrl, downloadExpiresAt, additionalProperties);
        }
    }
}
