/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.events.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ListEventSummariesRequest.Builder.class)
public final class ListEventSummariesRequest {
    private final Optional<String> userId;

    private final Optional<EventSummaries> eventSummaries;

    private final Map<String, Object> additionalProperties;

    private ListEventSummariesRequest(
            Optional<String> userId,
            Optional<EventSummaries> eventSummaries,
            Map<String, Object> additionalProperties) {
        this.userId = userId;
        this.eventSummaries = eventSummaries;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Your identifier for the user.
     */
    @JsonProperty("user_id")
    public Optional<String> getUserId() {
        return userId;
    }

    /**
     * @return A list of event summaries for the user. Each event summary should contain the event name, the time the event occurred, and the number of times the event occurred. The event name should be a past tense 'verb-noun' combination, to improve readability, for example <code>updated-plan</code>.
     */
    @JsonProperty("event_summaries")
    public Optional<EventSummaries> getEventSummaries() {
        return eventSummaries;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ListEventSummariesRequest && equalTo((ListEventSummariesRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListEventSummariesRequest other) {
        return userId.equals(other.userId) && eventSummaries.equals(other.eventSummaries);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.userId, this.eventSummaries);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> userId = Optional.empty();

        private Optional<EventSummaries> eventSummaries = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(ListEventSummariesRequest other) {
            userId(other.getUserId());
            eventSummaries(other.getEventSummaries());
            return this;
        }

        /**
         * <p>Your identifier for the user.</p>
         */
        @JsonSetter(value = "user_id", nulls = Nulls.SKIP)
        public Builder userId(Optional<String> userId) {
            this.userId = userId;
            return this;
        }

        public Builder userId(String userId) {
            this.userId = Optional.ofNullable(userId);
            return this;
        }

        /**
         * <p>A list of event summaries for the user. Each event summary should contain the event name, the time the event occurred, and the number of times the event occurred. The event name should be a past tense 'verb-noun' combination, to improve readability, for example <code>updated-plan</code>.</p>
         */
        @JsonSetter(value = "event_summaries", nulls = Nulls.SKIP)
        public Builder eventSummaries(Optional<EventSummaries> eventSummaries) {
            this.eventSummaries = eventSummaries;
            return this;
        }

        public Builder eventSummaries(EventSummaries eventSummaries) {
            this.eventSummaries = Optional.ofNullable(eventSummaries);
            return this;
        }

        public ListEventSummariesRequest build() {
            return new ListEventSummariesRequest(userId, eventSummaries, additionalProperties);
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = EventSummaries.Builder.class)
    public static final class EventSummaries {
        private final Optional<String> eventName;

        private final Optional<Integer> count;

        private final Optional<Integer> first;

        private final Optional<Integer> last;

        private final Map<String, Object> additionalProperties;

        private EventSummaries(
                Optional<String> eventName,
                Optional<Integer> count,
                Optional<Integer> first,
                Optional<Integer> last,
                Map<String, Object> additionalProperties) {
            this.eventName = eventName;
            this.count = count;
            this.first = first;
            this.last = last;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return The name of the event that occurred. A good event name is typically a past tense 'verb-noun' combination, to improve readability, for example <code>updated-plan</code>.
         */
        @JsonProperty("event_name")
        public Optional<String> getEventName() {
            return eventName;
        }

        /**
         * @return The number of times the event occurred.
         */
        @JsonProperty("count")
        public Optional<Integer> getCount() {
            return count;
        }

        /**
         * @return The first time the event was sent
         */
        @JsonProperty("first")
        public Optional<Integer> getFirst() {
            return first;
        }

        /**
         * @return The last time the event was sent
         */
        @JsonProperty("last")
        public Optional<Integer> getLast() {
            return last;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof EventSummaries && equalTo((EventSummaries) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(EventSummaries other) {
            return eventName.equals(other.eventName)
                    && count.equals(other.count)
                    && first.equals(other.first)
                    && last.equals(other.last);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.eventName, this.count, this.first, this.last);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder {
            private Optional<String> eventName = Optional.empty();

            private Optional<Integer> count = Optional.empty();

            private Optional<Integer> first = Optional.empty();

            private Optional<Integer> last = Optional.empty();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            public Builder from(EventSummaries other) {
                eventName(other.getEventName());
                count(other.getCount());
                first(other.getFirst());
                last(other.getLast());
                return this;
            }

            /**
             * <p>The name of the event that occurred. A good event name is typically a past tense 'verb-noun' combination, to improve readability, for example <code>updated-plan</code>.</p>
             */
            @JsonSetter(value = "event_name", nulls = Nulls.SKIP)
            public Builder eventName(Optional<String> eventName) {
                this.eventName = eventName;
                return this;
            }

            public Builder eventName(String eventName) {
                this.eventName = Optional.ofNullable(eventName);
                return this;
            }

            /**
             * <p>The number of times the event occurred.</p>
             */
            @JsonSetter(value = "count", nulls = Nulls.SKIP)
            public Builder count(Optional<Integer> count) {
                this.count = count;
                return this;
            }

            public Builder count(Integer count) {
                this.count = Optional.ofNullable(count);
                return this;
            }

            /**
             * <p>The first time the event was sent</p>
             */
            @JsonSetter(value = "first", nulls = Nulls.SKIP)
            public Builder first(Optional<Integer> first) {
                this.first = first;
                return this;
            }

            public Builder first(Integer first) {
                this.first = Optional.ofNullable(first);
                return this;
            }

            /**
             * <p>The last time the event was sent</p>
             */
            @JsonSetter(value = "last", nulls = Nulls.SKIP)
            public Builder last(Optional<Integer> last) {
                this.last = last;
                return this;
            }

            public Builder last(Integer last) {
                this.last = Optional.ofNullable(last);
                return this;
            }

            public EventSummaries build() {
                return new EventSummaries(eventName, count, first, last, additionalProperties);
            }
        }
    }
}
