/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.export;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.IntercomApiException;
import com.intercom.api.core.IntercomException;
import com.intercom.api.core.IntercomHttpResponse;
import com.intercom.api.core.MediaTypes;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.errors.BadRequestError;
import com.intercom.api.errors.TooManyRequestsError;
import com.intercom.api.errors.UnauthorizedError;
import com.intercom.api.resources.export.requests.PostExportReportingDataEnqueueRequest;
import com.intercom.api.resources.export.types.GetExportReportingDataGetDatasetsResponse;
import com.intercom.api.resources.export.types.PostExportReportingDataEnqueueResponse;
import com.intercom.api.types.Error;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

public class AsyncRawExportClient {
    protected final ClientOptions clientOptions;

    public AsyncRawExportClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public CompletableFuture<IntercomHttpResponse<PostExportReportingDataEnqueueResponse>>
            enqueueANewReportingDataExportJob(PostExportReportingDataEnqueueRequest request) {
        return enqueueANewReportingDataExportJob(request, null);
    }

    public CompletableFuture<IntercomHttpResponse<PostExportReportingDataEnqueueResponse>>
            enqueueANewReportingDataExportJob(
                    PostExportReportingDataEnqueueRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("export/reporting_data/enqueue")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new IntercomException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<IntercomHttpResponse<PostExportReportingDataEnqueueResponse>> future =
                new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new IntercomHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBodyString, PostExportReportingDataEnqueueResponse.class),
                                response));
                        return;
                    }
                    try {
                        switch (response.code()) {
                            case 400:
                                future.completeExceptionally(new BadRequestError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                                        response));
                                return;
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class),
                                        response));
                                return;
                            case 429:
                                future.completeExceptionally(new TooManyRequestsError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
                    future.completeExceptionally(new IntercomApiException(
                            "Error with status code " + response.code(), response.code(), errorBody, response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<IntercomHttpResponse<GetExportReportingDataGetDatasetsResponse>>
            listAvailableDatasetsAndAttributes() {
        return listAvailableDatasetsAndAttributes(null);
    }

    public CompletableFuture<IntercomHttpResponse<GetExportReportingDataGetDatasetsResponse>>
            listAvailableDatasetsAndAttributes(RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("export/reporting_data/get_datasets")
                .build();
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<IntercomHttpResponse<GetExportReportingDataGetDatasetsResponse>> future =
                new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new IntercomHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBodyString, GetExportReportingDataGetDatasetsResponse.class),
                                response));
                        return;
                    }
                    Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
                    future.completeExceptionally(new IntercomApiException(
                            "Error with status code " + response.code(), response.code(), errorBody, response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
            }
        });
        return future;
    }
}
