/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.internalarticles;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.IntercomApiException;
import com.intercom.api.core.IntercomException;
import com.intercom.api.core.IntercomHttpResponse;
import com.intercom.api.core.MediaTypes;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.core.QueryStringMapper;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.errors.BadRequestError;
import com.intercom.api.errors.NotFoundError;
import com.intercom.api.errors.UnauthorizedError;
import com.intercom.api.resources.internalarticles.requests.DeleteInternalArticleRequest;
import com.intercom.api.resources.internalarticles.requests.RetrieveInternalArticleRequest;
import com.intercom.api.resources.internalarticles.requests.SearchInternalArticlesRequest;
import com.intercom.api.resources.internalarticles.requests.UpdateInternalArticleRequestBody;
import com.intercom.api.resources.internalarticles.types.InternalArticleListItem;
import com.intercom.api.resources.internalarticles.types.InternalArticleSearchResponse;
import com.intercom.api.types.CreateInternalArticleRequest;
import com.intercom.api.types.DeletedInternalArticleObject;
import com.intercom.api.types.Error;
import com.intercom.api.types.InternalArticleList;
import java.io.IOException;
import java.util.Optional;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawInternalArticlesClient {
    protected final ClientOptions clientOptions;

    public RawInternalArticlesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    /**
     * You can fetch a list of all internal articles by making a GET request to <code>https://api.intercom.io/internal_articles</code>.
     */
    public IntercomHttpResponse<InternalArticleList> listInternalArticles() {
        return listInternalArticles(null);
    }

    /**
     * You can fetch a list of all internal articles by making a GET request to <code>https://api.intercom.io/internal_articles</code>.
     */
    public IntercomHttpResponse<InternalArticleList> listInternalArticles(RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("internal_articles")
                .build();
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new IntercomHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, InternalArticleList.class), response);
            }
            try {
                if (response.code() == 401) {
                    throw new UnauthorizedError(
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new IntercomApiException(
                    "Error with status code " + response.code(), response.code(), errorBody, response);
        } catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }

    /**
     * You can create a new internal article by making a POST request to <code>https://api.intercom.io/internal_articles</code>.
     */
    public IntercomHttpResponse<InternalArticleListItem> createInternalArticle() {
        return createInternalArticle(Optional.empty());
    }

    /**
     * You can create a new internal article by making a POST request to <code>https://api.intercom.io/internal_articles</code>.
     */
    public IntercomHttpResponse<InternalArticleListItem> createInternalArticle(
            Optional<CreateInternalArticleRequest> request) {
        return createInternalArticle(request, null);
    }

    /**
     * You can create a new internal article by making a POST request to <code>https://api.intercom.io/internal_articles</code>.
     */
    public IntercomHttpResponse<InternalArticleListItem> createInternalArticle(
            Optional<CreateInternalArticleRequest> request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("internal_articles")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create("", null);
            if (request.isPresent()) {
                body = RequestBody.create(
                        ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
            }
        } catch (JsonProcessingException e) {
            throw new IntercomException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new IntercomHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, InternalArticleListItem.class),
                        response);
            }
            try {
                switch (response.code()) {
                    case 400:
                        throw new BadRequestError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    case 401:
                        throw new UnauthorizedError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new IntercomApiException(
                    "Error with status code " + response.code(), response.code(), errorBody, response);
        } catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }

    /**
     * You can fetch the details of a single internal article by making a GET request to <code>https://api.intercom.io/internal_articles/&lt;id&gt;</code>.
     */
    public IntercomHttpResponse<InternalArticleListItem> retrieveInternalArticle(
            RetrieveInternalArticleRequest request) {
        return retrieveInternalArticle(request, null);
    }

    /**
     * You can fetch the details of a single internal article by making a GET request to <code>https://api.intercom.io/internal_articles/&lt;id&gt;</code>.
     */
    public IntercomHttpResponse<InternalArticleListItem> retrieveInternalArticle(
            RetrieveInternalArticleRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("internal_articles")
                .addPathSegment(Integer.toString(request.getInternalArticleId()))
                .build();
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl)
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new IntercomHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, InternalArticleListItem.class),
                        response);
            }
            try {
                switch (response.code()) {
                    case 401:
                        throw new UnauthorizedError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                    case 404:
                        throw new NotFoundError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new IntercomApiException(
                    "Error with status code " + response.code(), response.code(), errorBody, response);
        } catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }

    /**
     * You can update the details of a single internal article by making a PUT request to <code>https://api.intercom.io/internal_articles/&lt;id&gt;</code>.
     */
    public IntercomHttpResponse<InternalArticleListItem> updateInternalArticle(
            UpdateInternalArticleRequestBody request) {
        return updateInternalArticle(request, null);
    }

    /**
     * You can update the details of a single internal article by making a PUT request to <code>https://api.intercom.io/internal_articles/&lt;id&gt;</code>.
     */
    public IntercomHttpResponse<InternalArticleListItem> updateInternalArticle(
            UpdateInternalArticleRequestBody request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("internal_articles")
                .addPathSegment(Integer.toString(request.getInternalArticleId()))
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new IntercomException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("PUT", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new IntercomHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, InternalArticleListItem.class),
                        response);
            }
            try {
                switch (response.code()) {
                    case 401:
                        throw new UnauthorizedError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                    case 404:
                        throw new NotFoundError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new IntercomApiException(
                    "Error with status code " + response.code(), response.code(), errorBody, response);
        } catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }

    /**
     * You can delete a single internal article by making a DELETE request to <code>https://api.intercom.io/internal_articles/&lt;id&gt;</code>.
     */
    public IntercomHttpResponse<DeletedInternalArticleObject> deleteInternalArticle(
            DeleteInternalArticleRequest request) {
        return deleteInternalArticle(request, null);
    }

    /**
     * You can delete a single internal article by making a DELETE request to <code>https://api.intercom.io/internal_articles/&lt;id&gt;</code>.
     */
    public IntercomHttpResponse<DeletedInternalArticleObject> deleteInternalArticle(
            DeleteInternalArticleRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("internal_articles")
                .addPathSegment(Integer.toString(request.getInternalArticleId()))
                .build();
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl)
                .method("DELETE", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new IntercomHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, DeletedInternalArticleObject.class),
                        response);
            }
            try {
                switch (response.code()) {
                    case 401:
                        throw new UnauthorizedError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                    case 404:
                        throw new NotFoundError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new IntercomApiException(
                    "Error with status code " + response.code(), response.code(), errorBody, response);
        } catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }

    /**
     * You can search for internal articles by making a GET request to <code>https://api.intercom.io/internal_articles/search</code>.
     */
    public IntercomHttpResponse<InternalArticleSearchResponse> searchInternalArticles() {
        return searchInternalArticles(SearchInternalArticlesRequest.builder().build());
    }

    /**
     * You can search for internal articles by making a GET request to <code>https://api.intercom.io/internal_articles/search</code>.
     */
    public IntercomHttpResponse<InternalArticleSearchResponse> searchInternalArticles(
            SearchInternalArticlesRequest request) {
        return searchInternalArticles(request, null);
    }

    /**
     * You can search for internal articles by making a GET request to <code>https://api.intercom.io/internal_articles/search</code>.
     */
    public IntercomHttpResponse<InternalArticleSearchResponse> searchInternalArticles(
            SearchInternalArticlesRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("internal_articles/search");
        if (request.getFolderId().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "folder_id", request.getFolderId().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl.build())
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new IntercomHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, InternalArticleSearchResponse.class),
                        response);
            }
            try {
                if (response.code() == 401) {
                    throw new UnauthorizedError(
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new IntercomApiException(
                    "Error with status code " + response.code(), response.code(), errorBody, response);
        } catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }
}
