/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.jobs.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = JobsStatusRequest.Builder.class)
public final class JobsStatusRequest {
    private final String jobId;

    private final Map<String, Object> additionalProperties;

    private JobsStatusRequest(String jobId, Map<String, Object> additionalProperties) {
        this.jobId = jobId;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The unique identifier for the job which is given by Intercom
     */
    @JsonProperty("job_id")
    public String getJobId() {
        return jobId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof JobsStatusRequest && equalTo((JobsStatusRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(JobsStatusRequest other) {
        return jobId.equals(other.jobId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.jobId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static JobIdStage builder() {
        return new Builder();
    }

    public interface JobIdStage {
        /**
         * <p>The unique identifier for the job which is given by Intercom</p>
         */
        _FinalStage jobId(@NotNull String jobId);

        Builder from(JobsStatusRequest other);
    }

    public interface _FinalStage {
        JobsStatusRequest build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements JobIdStage, _FinalStage {
        private String jobId;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(JobsStatusRequest other) {
            jobId(other.getJobId());
            return this;
        }

        /**
         * <p>The unique identifier for the job which is given by Intercom</p>
         * <p>The unique identifier for the job which is given by Intercom</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("job_id")
        public _FinalStage jobId(@NotNull String jobId) {
            this.jobId = Objects.requireNonNull(jobId, "jobId must not be null");
            return this;
        }

        @java.lang.Override
        public JobsStatusRequest build() {
            return new JobsStatusRequest(jobId, additionalProperties);
        }
    }
}
