/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.notes.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.admins.types.Admin;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = Note.Builder.class)
public final class Note {
    private final String type;

    private final String id;

    private final int createdAt;

    private final Optional<Contact> contact;

    private final Optional<Admin> author;

    private final String body;

    private final Map<String, Object> additionalProperties;

    private Note(
            String type,
            String id,
            int createdAt,
            Optional<Contact> contact,
            Optional<Admin> author,
            String body,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.createdAt = createdAt;
        this.contact = contact;
        this.author = author;
        this.body = body;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return String representing the object's type. Always has the value <code>note</code>.
     */
    @JsonProperty("type")
    public String getType() {
        return type;
    }

    /**
     * @return The id of the note.
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    /**
     * @return The time the note was created.
     */
    @JsonProperty("created_at")
    public int getCreatedAt() {
        return createdAt;
    }

    /**
     * @return Represents the contact that the note was created about.
     */
    @JsonProperty("contact")
    public Optional<Contact> getContact() {
        return contact;
    }

    /**
     * @return Optional. Represents the Admin that created the note.
     */
    @JsonProperty("author")
    public Optional<Admin> getAuthor() {
        return author;
    }

    /**
     * @return The body text of the note.
     */
    @JsonProperty("body")
    public String getBody() {
        return body;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof Note && equalTo((Note) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Note other) {
        return type.equals(other.type)
                && id.equals(other.id)
                && createdAt == other.createdAt
                && contact.equals(other.contact)
                && author.equals(other.author)
                && body.equals(other.body);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.type, this.id, this.createdAt, this.contact, this.author, this.body);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TypeStage builder() {
        return new Builder();
    }

    public interface TypeStage {
        /**
         * <p>String representing the object's type. Always has the value <code>note</code>.</p>
         */
        IdStage type(@NotNull String type);

        Builder from(Note other);
    }

    public interface IdStage {
        /**
         * <p>The id of the note.</p>
         */
        CreatedAtStage id(@NotNull String id);
    }

    public interface CreatedAtStage {
        /**
         * <p>The time the note was created.</p>
         */
        BodyStage createdAt(int createdAt);
    }

    public interface BodyStage {
        /**
         * <p>The body text of the note.</p>
         */
        _FinalStage body(@NotNull String body);
    }

    public interface _FinalStage {
        Note build();

        /**
         * <p>Represents the contact that the note was created about.</p>
         */
        _FinalStage contact(Optional<Contact> contact);

        _FinalStage contact(Contact contact);

        /**
         * <p>Optional. Represents the Admin that created the note.</p>
         */
        _FinalStage author(Optional<Admin> author);

        _FinalStage author(Admin author);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TypeStage, IdStage, CreatedAtStage, BodyStage, _FinalStage {
        private String type;

        private String id;

        private int createdAt;

        private String body;

        private Optional<Admin> author = Optional.empty();

        private Optional<Contact> contact = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(Note other) {
            type(other.getType());
            id(other.getId());
            createdAt(other.getCreatedAt());
            contact(other.getContact());
            author(other.getAuthor());
            body(other.getBody());
            return this;
        }

        /**
         * <p>String representing the object's type. Always has the value <code>note</code>.</p>
         * <p>String representing the object's type. Always has the value <code>note</code>.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("type")
        public IdStage type(@NotNull String type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        /**
         * <p>The id of the note.</p>
         * <p>The id of the note.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public CreatedAtStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        /**
         * <p>The time the note was created.</p>
         * <p>The time the note was created.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("created_at")
        public BodyStage createdAt(int createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        /**
         * <p>The body text of the note.</p>
         * <p>The body text of the note.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("body")
        public _FinalStage body(@NotNull String body) {
            this.body = Objects.requireNonNull(body, "body must not be null");
            return this;
        }

        /**
         * <p>Optional. Represents the Admin that created the note.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage author(Admin author) {
            this.author = Optional.ofNullable(author);
            return this;
        }

        /**
         * <p>Optional. Represents the Admin that created the note.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "author", nulls = Nulls.SKIP)
        public _FinalStage author(Optional<Admin> author) {
            this.author = author;
            return this;
        }

        /**
         * <p>Represents the contact that the note was created about.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage contact(Contact contact) {
            this.contact = Optional.ofNullable(contact);
            return this;
        }

        /**
         * <p>Represents the contact that the note was created about.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "contact", nulls = Nulls.SKIP)
        public _FinalStage contact(Optional<Contact> contact) {
            this.contact = contact;
            return this;
        }

        @java.lang.Override
        public Note build() {
            return new Note(type, id, createdAt, contact, author, body, additionalProperties);
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = Contact.Builder.class)
    public static final class Contact {
        private final Optional<String> type;

        private final Optional<String> id;

        private final Map<String, Object> additionalProperties;

        private Contact(Optional<String> type, Optional<String> id, Map<String, Object> additionalProperties) {
            this.type = type;
            this.id = id;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return String representing the object's type. Always has the value <code>contact</code>.
         */
        @JsonProperty("type")
        public Optional<String> getType() {
            return type;
        }

        /**
         * @return The id of the contact.
         */
        @JsonProperty("id")
        public Optional<String> getId() {
            return id;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof Contact && equalTo((Contact) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Contact other) {
            return type.equals(other.type) && id.equals(other.id);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.type, this.id);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder {
            private Optional<String> type = Optional.empty();

            private Optional<String> id = Optional.empty();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            public Builder from(Contact other) {
                type(other.getType());
                id(other.getId());
                return this;
            }

            /**
             * <p>String representing the object's type. Always has the value <code>contact</code>.</p>
             */
            @JsonSetter(value = "type", nulls = Nulls.SKIP)
            public Builder type(Optional<String> type) {
                this.type = type;
                return this;
            }

            public Builder type(String type) {
                this.type = Optional.ofNullable(type);
                return this;
            }

            /**
             * <p>The id of the contact.</p>
             */
            @JsonSetter(value = "id", nulls = Nulls.SKIP)
            public Builder id(Optional<String> id) {
                this.id = id;
                return this;
            }

            public Builder id(String id) {
                this.id = Optional.ofNullable(id);
                return this;
            }

            public Contact build() {
                return new Contact(type, id, additionalProperties);
            }
        }
    }
}
