/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.segments.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ListSegmentsRequest.Builder.class)
public final class ListSegmentsRequest {
    private final Optional<Boolean> includeCount;

    private final Map<String, Object> additionalProperties;

    private ListSegmentsRequest(Optional<Boolean> includeCount, Map<String, Object> additionalProperties) {
        this.includeCount = includeCount;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return It includes the count of contacts that belong to each segment.
     */
    @JsonProperty("include_count")
    public Optional<Boolean> getIncludeCount() {
        return includeCount;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ListSegmentsRequest && equalTo((ListSegmentsRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListSegmentsRequest other) {
        return includeCount.equals(other.includeCount);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.includeCount);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<Boolean> includeCount = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(ListSegmentsRequest other) {
            includeCount(other.getIncludeCount());
            return this;
        }

        /**
         * <p>It includes the count of contacts that belong to each segment.</p>
         */
        @JsonSetter(value = "include_count", nulls = Nulls.SKIP)
        public Builder includeCount(Optional<Boolean> includeCount) {
            this.includeCount = includeCount;
            return this;
        }

        public Builder includeCount(Boolean includeCount) {
            this.includeCount = Optional.ofNullable(includeCount);
            return this;
        }

        public ListSegmentsRequest build() {
            return new ListSegmentsRequest(includeCount, additionalProperties);
        }
    }
}
