/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.tags.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = TagContactRequest.Builder.class)
public final class TagContactRequest {
    private final String contactId;

    private final String tagId;

    private final Map<String, Object> additionalProperties;

    private TagContactRequest(String contactId, String tagId, Map<String, Object> additionalProperties) {
        this.contactId = contactId;
        this.tagId = tagId;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The unique identifier for the contact which is given by Intercom
     */
    @JsonProperty("contact_id")
    public String getContactId() {
        return contactId;
    }

    /**
     * @return The unique identifier for the tag which is given by Intercom
     */
    @JsonProperty("id")
    public String getTagId() {
        return tagId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof TagContactRequest && equalTo((TagContactRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TagContactRequest other) {
        return contactId.equals(other.contactId) && tagId.equals(other.tagId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.contactId, this.tagId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ContactIdStage builder() {
        return new Builder();
    }

    public interface ContactIdStage {
        /**
         * <p>The unique identifier for the contact which is given by Intercom</p>
         */
        TagIdStage contactId(@NotNull String contactId);

        Builder from(TagContactRequest other);
    }

    public interface TagIdStage {
        /**
         * <p>The unique identifier for the tag which is given by Intercom</p>
         */
        _FinalStage tagId(@NotNull String tagId);
    }

    public interface _FinalStage {
        TagContactRequest build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements ContactIdStage, TagIdStage, _FinalStage {
        private String contactId;

        private String tagId;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(TagContactRequest other) {
            contactId(other.getContactId());
            tagId(other.getTagId());
            return this;
        }

        /**
         * <p>The unique identifier for the contact which is given by Intercom</p>
         * <p>The unique identifier for the contact which is given by Intercom</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("contact_id")
        public TagIdStage contactId(@NotNull String contactId) {
            this.contactId = Objects.requireNonNull(contactId, "contactId must not be null");
            return this;
        }

        /**
         * <p>The unique identifier for the tag which is given by Intercom</p>
         * <p>The unique identifier for the tag which is given by Intercom</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public _FinalStage tagId(@NotNull String tagId) {
            this.tagId = Objects.requireNonNull(tagId, "tagId must not be null");
            return this;
        }

        @java.lang.Override
        public TagContactRequest build() {
            return new TagContactRequest(contactId, tagId, additionalProperties);
        }
    }
}
