/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.tickets.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = FindTicketRequest.Builder.class)
public final class FindTicketRequest {
    private final String ticketId;

    private final Map<String, Object> additionalProperties;

    private FindTicketRequest(String ticketId, Map<String, Object> additionalProperties) {
        this.ticketId = ticketId;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The unique identifier for the ticket which is given by Intercom.
     */
    @JsonProperty("ticket_id")
    public String getTicketId() {
        return ticketId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof FindTicketRequest && equalTo((FindTicketRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(FindTicketRequest other) {
        return ticketId.equals(other.ticketId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.ticketId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TicketIdStage builder() {
        return new Builder();
    }

    public interface TicketIdStage {
        /**
         * <p>The unique identifier for the ticket which is given by Intercom.</p>
         */
        _FinalStage ticketId(@NotNull String ticketId);

        Builder from(FindTicketRequest other);
    }

    public interface _FinalStage {
        FindTicketRequest build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TicketIdStage, _FinalStage {
        private String ticketId;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(FindTicketRequest other) {
            ticketId(other.getTicketId());
            return this;
        }

        /**
         * <p>The unique identifier for the ticket which is given by Intercom.</p>
         * <p>The unique identifier for the ticket which is given by Intercom.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("ticket_id")
        public _FinalStage ticketId(@NotNull String ticketId) {
            this.ticketId = Objects.requireNonNull(ticketId, "ticketId must not be null");
            return this;
        }

        @java.lang.Override
        public FindTicketRequest build() {
            return new FindTicketRequest(ticketId, additionalProperties);
        }
    }
}
