/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.calls;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.calls.requests.CollectFinVoiceCallByExternalIdRequest;
import com.intercom.api.resources.unstable.calls.requests.CollectFinVoiceCallByIdRequest;
import com.intercom.api.resources.unstable.calls.requests.CollectFinVoiceCallByPhoneNumberRequest;
import com.intercom.api.resources.unstable.calls.requests.ListCallsRequest;
import com.intercom.api.resources.unstable.calls.requests.ListCallsWithTranscriptsRequest;
import com.intercom.api.resources.unstable.calls.requests.ShowCallRecordingRequest;
import com.intercom.api.resources.unstable.calls.requests.ShowCallRequest;
import com.intercom.api.resources.unstable.calls.requests.ShowCallTranscriptRequest;
import com.intercom.api.resources.unstable.calls.types.Call;
import com.intercom.api.resources.unstable.calls.types.ListCallsWithTranscriptsResponse;
import com.intercom.api.resources.unstable.types.AiCallResponse;
import com.intercom.api.resources.unstable.types.CallList;
import com.intercom.api.resources.unstable.types.Error;
import com.intercom.api.resources.unstable.types.RegisterFinVoiceCallRequest;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class AsyncCallsClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawCallsClient rawClient;

    public AsyncCallsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawCallsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawCallsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Retrieve a paginated list of calls.
     */
    public CompletableFuture<CallList> listCalls() {
        return this.rawClient.listCalls().thenApply(response -> response.body());
    }

    /**
     * Retrieve a paginated list of calls.
     */
    public CompletableFuture<CallList> listCalls(ListCallsRequest request) {
        return this.rawClient.listCalls(request).thenApply(response -> response.body());
    }

    /**
     * Retrieve a paginated list of calls.
     */
    public CompletableFuture<CallList> listCalls(ListCallsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listCalls(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Retrieve a single call by id.
     */
    public CompletableFuture<Call> showCall(ShowCallRequest request) {
        return this.rawClient.showCall(request).thenApply(response -> response.body());
    }

    /**
     * Retrieve a single call by id.
     */
    public CompletableFuture<Call> showCall(ShowCallRequest request, RequestOptions requestOptions) {
        return this.rawClient.showCall(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Redirects to a signed URL for the call's recording if it exists.
     */
    public CompletableFuture<Void> showCallRecording(ShowCallRecordingRequest request) {
        return this.rawClient.showCallRecording(request).thenApply(response -> response.body());
    }

    /**
     * Redirects to a signed URL for the call's recording if it exists.
     */
    public CompletableFuture<Void> showCallRecording(ShowCallRecordingRequest request, RequestOptions requestOptions) {
        return this.rawClient.showCallRecording(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Returns the transcript for the specified call as a downloadable text file.
     */
    public CompletableFuture<String> showCallTranscript(ShowCallTranscriptRequest request) {
        return this.rawClient.showCallTranscript(request).thenApply(response -> response.body());
    }

    /**
     * Returns the transcript for the specified call as a downloadable text file.
     */
    public CompletableFuture<String> showCallTranscript(
            ShowCallTranscriptRequest request, RequestOptions requestOptions) {
        return this.rawClient.showCallTranscript(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Retrieve calls by a list of conversation ids and include transcripts when available.
     * A maximum of 20 <code>conversation_ids</code> can be provided. If none are provided or more than 20 are provided, a 400 error is returned.
     */
    public CompletableFuture<ListCallsWithTranscriptsResponse> listCallsWithTranscripts(
            ListCallsWithTranscriptsRequest request) {
        return this.rawClient.listCallsWithTranscripts(request).thenApply(response -> response.body());
    }

    /**
     * Retrieve calls by a list of conversation ids and include transcripts when available.
     * A maximum of 20 <code>conversation_ids</code> can be provided. If none are provided or more than 20 are provided, a 400 error is returned.
     */
    public CompletableFuture<ListCallsWithTranscriptsResponse> listCallsWithTranscripts(
            ListCallsWithTranscriptsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listCallsWithTranscripts(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Register a Fin Voice call with Intercom. This endpoint creates an external reference
     * that links an external call identifier to an Intercom call and conversation.
     * <p>The call can be from different sources:</p>
     * <ul>
     * <li>AWS Connect (default)</li>
     * <li>Five9</li>
     * <li>Zoom Phone</li>
     * </ul>
     */
    public CompletableFuture<AiCallResponse> registerFinVoiceCall() {
        return this.rawClient.registerFinVoiceCall().thenApply(response -> response.body());
    }

    /**
     * Register a Fin Voice call with Intercom. This endpoint creates an external reference
     * that links an external call identifier to an Intercom call and conversation.
     * <p>The call can be from different sources:</p>
     * <ul>
     * <li>AWS Connect (default)</li>
     * <li>Five9</li>
     * <li>Zoom Phone</li>
     * </ul>
     */
    public CompletableFuture<AiCallResponse> registerFinVoiceCall(Optional<RegisterFinVoiceCallRequest> request) {
        return this.rawClient.registerFinVoiceCall(request).thenApply(response -> response.body());
    }

    /**
     * Register a Fin Voice call with Intercom. This endpoint creates an external reference
     * that links an external call identifier to an Intercom call and conversation.
     * <p>The call can be from different sources:</p>
     * <ul>
     * <li>AWS Connect (default)</li>
     * <li>Five9</li>
     * <li>Zoom Phone</li>
     * </ul>
     */
    public CompletableFuture<AiCallResponse> registerFinVoiceCall(
            Optional<RegisterFinVoiceCallRequest> request, RequestOptions requestOptions) {
        return this.rawClient.registerFinVoiceCall(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Retrieve information about a Fin Voice call using the external reference ID.
     */
    public CompletableFuture<AiCallResponse> collectFinVoiceCallById(CollectFinVoiceCallByIdRequest request) {
        return this.rawClient.collectFinVoiceCallById(request).thenApply(response -> response.body());
    }

    /**
     * Retrieve information about a Fin Voice call using the external reference ID.
     */
    public CompletableFuture<AiCallResponse> collectFinVoiceCallById(
            CollectFinVoiceCallByIdRequest request, RequestOptions requestOptions) {
        return this.rawClient.collectFinVoiceCallById(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Retrieve information about a Fin Voice call using the external call identifier.
     */
    public CompletableFuture<AiCallResponse> collectFinVoiceCallByExternalId(
            CollectFinVoiceCallByExternalIdRequest request) {
        return this.rawClient.collectFinVoiceCallByExternalId(request).thenApply(response -> response.body());
    }

    /**
     * Retrieve information about a Fin Voice call using the external call identifier.
     */
    public CompletableFuture<AiCallResponse> collectFinVoiceCallByExternalId(
            CollectFinVoiceCallByExternalIdRequest request, RequestOptions requestOptions) {
        return this.rawClient
                .collectFinVoiceCallByExternalId(request, requestOptions)
                .thenApply(response -> response.body());
    }

    /**
     * Retrieve information about a Fin Voice call using the phone number.
     * <p>Returns the most recent matched call for the given phone number, ordered by creation date.</p>
     */
    public CompletableFuture<Error> collectFinVoiceCallByPhoneNumber(CollectFinVoiceCallByPhoneNumberRequest request) {
        return this.rawClient.collectFinVoiceCallByPhoneNumber(request).thenApply(response -> response.body());
    }

    /**
     * Retrieve information about a Fin Voice call using the phone number.
     * <p>Returns the most recent matched call for the given phone number, ordered by creation date.</p>
     */
    public CompletableFuture<Error> collectFinVoiceCallByPhoneNumber(
            CollectFinVoiceCallByPhoneNumberRequest request, RequestOptions requestOptions) {
        return this.rawClient
                .collectFinVoiceCallByPhoneNumber(request, requestOptions)
                .thenApply(response -> response.body());
    }
}
