/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.calls.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CollectFinVoiceCallByExternalIdRequest.Builder.class)
public final class CollectFinVoiceCallByExternalIdRequest {
    private final String externalId;

    private final Map<String, Object> additionalProperties;

    private CollectFinVoiceCallByExternalIdRequest(String externalId, Map<String, Object> additionalProperties) {
        this.externalId = externalId;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The external call identifier from the call provider
     */
    @JsonProperty("external_id")
    public String getExternalId() {
        return externalId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CollectFinVoiceCallByExternalIdRequest
                && equalTo((CollectFinVoiceCallByExternalIdRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CollectFinVoiceCallByExternalIdRequest other) {
        return externalId.equals(other.externalId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.externalId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ExternalIdStage builder() {
        return new Builder();
    }

    public interface ExternalIdStage {
        /**
         * <p>The external call identifier from the call provider</p>
         */
        _FinalStage externalId(@NotNull String externalId);

        Builder from(CollectFinVoiceCallByExternalIdRequest other);
    }

    public interface _FinalStage {
        CollectFinVoiceCallByExternalIdRequest build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements ExternalIdStage, _FinalStage {
        private String externalId;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CollectFinVoiceCallByExternalIdRequest other) {
            externalId(other.getExternalId());
            return this;
        }

        /**
         * <p>The external call identifier from the call provider</p>
         * <p>The external call identifier from the call provider</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("external_id")
        public _FinalStage externalId(@NotNull String externalId) {
            this.externalId = Objects.requireNonNull(externalId, "externalId must not be null");
            return this;
        }

        @java.lang.Override
        public CollectFinVoiceCallByExternalIdRequest build() {
            return new CollectFinVoiceCallByExternalIdRequest(externalId, additionalProperties);
        }
    }
}
