/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.calls.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CollectFinVoiceCallByPhoneNumberRequest.Builder.class)
public final class CollectFinVoiceCallByPhoneNumberRequest {
    private final String phoneNumber;

    private final Map<String, Object> additionalProperties;

    private CollectFinVoiceCallByPhoneNumberRequest(String phoneNumber, Map<String, Object> additionalProperties) {
        this.phoneNumber = phoneNumber;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Phone number in E.164 format
     */
    @JsonProperty("phone_number")
    public String getPhoneNumber() {
        return phoneNumber;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CollectFinVoiceCallByPhoneNumberRequest
                && equalTo((CollectFinVoiceCallByPhoneNumberRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CollectFinVoiceCallByPhoneNumberRequest other) {
        return phoneNumber.equals(other.phoneNumber);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.phoneNumber);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PhoneNumberStage builder() {
        return new Builder();
    }

    public interface PhoneNumberStage {
        /**
         * <p>Phone number in E.164 format</p>
         */
        _FinalStage phoneNumber(@NotNull String phoneNumber);

        Builder from(CollectFinVoiceCallByPhoneNumberRequest other);
    }

    public interface _FinalStage {
        CollectFinVoiceCallByPhoneNumberRequest build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements PhoneNumberStage, _FinalStage {
        private String phoneNumber;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CollectFinVoiceCallByPhoneNumberRequest other) {
            phoneNumber(other.getPhoneNumber());
            return this;
        }

        /**
         * <p>Phone number in E.164 format</p>
         * <p>Phone number in E.164 format</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("phone_number")
        public _FinalStage phoneNumber(@NotNull String phoneNumber) {
            this.phoneNumber = Objects.requireNonNull(phoneNumber, "phoneNumber must not be null");
            return this;
        }

        @java.lang.Override
        public CollectFinVoiceCallByPhoneNumberRequest build() {
            return new CollectFinVoiceCallByPhoneNumberRequest(phoneNumber, additionalProperties);
        }
    }
}
