/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.conversations.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = DetachContactFromConversationRequest.Builder.class)
public final class DetachContactFromConversationRequest {
    private final String conversationId;

    private final String contactId;

    private final String adminId;

    private final Map<String, Object> additionalProperties;

    private DetachContactFromConversationRequest(
            String conversationId, String contactId, String adminId, Map<String, Object> additionalProperties) {
        this.conversationId = conversationId;
        this.contactId = contactId;
        this.adminId = adminId;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The identifier for the conversation as given by Intercom.
     */
    @JsonProperty("conversation_id")
    public String getConversationId() {
        return conversationId;
    }

    /**
     * @return The identifier for the contact as given by Intercom.
     */
    @JsonProperty("contact_id")
    public String getContactId() {
        return contactId;
    }

    /**
     * @return The <code>id</code> of the admin who is performing the action.
     */
    @JsonProperty("admin_id")
    public String getAdminId() {
        return adminId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof DetachContactFromConversationRequest
                && equalTo((DetachContactFromConversationRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DetachContactFromConversationRequest other) {
        return conversationId.equals(other.conversationId)
                && contactId.equals(other.contactId)
                && adminId.equals(other.adminId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.conversationId, this.contactId, this.adminId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ConversationIdStage builder() {
        return new Builder();
    }

    public interface ConversationIdStage {
        /**
         * <p>The identifier for the conversation as given by Intercom.</p>
         */
        ContactIdStage conversationId(@NotNull String conversationId);

        Builder from(DetachContactFromConversationRequest other);
    }

    public interface ContactIdStage {
        /**
         * <p>The identifier for the contact as given by Intercom.</p>
         */
        AdminIdStage contactId(@NotNull String contactId);
    }

    public interface AdminIdStage {
        /**
         * <p>The <code>id</code> of the admin who is performing the action.</p>
         */
        _FinalStage adminId(@NotNull String adminId);
    }

    public interface _FinalStage {
        DetachContactFromConversationRequest build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements ConversationIdStage, ContactIdStage, AdminIdStage, _FinalStage {
        private String conversationId;

        private String contactId;

        private String adminId;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(DetachContactFromConversationRequest other) {
            conversationId(other.getConversationId());
            contactId(other.getContactId());
            adminId(other.getAdminId());
            return this;
        }

        /**
         * <p>The identifier for the conversation as given by Intercom.</p>
         * <p>The identifier for the conversation as given by Intercom.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("conversation_id")
        public ContactIdStage conversationId(@NotNull String conversationId) {
            this.conversationId = Objects.requireNonNull(conversationId, "conversationId must not be null");
            return this;
        }

        /**
         * <p>The identifier for the contact as given by Intercom.</p>
         * <p>The identifier for the contact as given by Intercom.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("contact_id")
        public AdminIdStage contactId(@NotNull String contactId) {
            this.contactId = Objects.requireNonNull(contactId, "contactId must not be null");
            return this;
        }

        /**
         * <p>The <code>id</code> of the admin who is performing the action.</p>
         * <p>The <code>id</code> of the admin who is performing the action.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("admin_id")
        public _FinalStage adminId(@NotNull String adminId) {
            this.adminId = Objects.requireNonNull(adminId, "adminId must not be null");
            return this;
        }

        @java.lang.Override
        public DetachContactFromConversationRequest build() {
            return new DetachContactFromConversationRequest(conversationId, contactId, adminId, additionalProperties);
        }
    }
}
