/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.conversations.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = RetrieveConversationRequest.Builder.class)
public final class RetrieveConversationRequest {
    private final int id;

    private final Optional<String> displayAs;

    private final Optional<Boolean> includeTranslations;

    private final Map<String, Object> additionalProperties;

    private RetrieveConversationRequest(
            int id,
            Optional<String> displayAs,
            Optional<Boolean> includeTranslations,
            Map<String, Object> additionalProperties) {
        this.id = id;
        this.displayAs = displayAs;
        this.includeTranslations = includeTranslations;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The id of the conversation to target
     */
    @JsonProperty("id")
    public int getId() {
        return id;
    }

    /**
     * @return Set to plaintext to retrieve conversation messages in plain text. This affects both the body and subject fields.
     */
    @JsonProperty("display_as")
    public Optional<String> getDisplayAs() {
        return displayAs;
    }

    /**
     * @return If set to true, conversation parts will be translated to the detected language of the conversation.
     */
    @JsonProperty("include_translations")
    public Optional<Boolean> getIncludeTranslations() {
        return includeTranslations;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof RetrieveConversationRequest && equalTo((RetrieveConversationRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(RetrieveConversationRequest other) {
        return id == other.id
                && displayAs.equals(other.displayAs)
                && includeTranslations.equals(other.includeTranslations);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.id, this.displayAs, this.includeTranslations);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public interface IdStage {
        /**
         * <p>The id of the conversation to target</p>
         */
        _FinalStage id(int id);

        Builder from(RetrieveConversationRequest other);
    }

    public interface _FinalStage {
        RetrieveConversationRequest build();

        /**
         * <p>Set to plaintext to retrieve conversation messages in plain text. This affects both the body and subject fields.</p>
         */
        _FinalStage displayAs(Optional<String> displayAs);

        _FinalStage displayAs(String displayAs);

        /**
         * <p>If set to true, conversation parts will be translated to the detected language of the conversation.</p>
         */
        _FinalStage includeTranslations(Optional<Boolean> includeTranslations);

        _FinalStage includeTranslations(Boolean includeTranslations);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements IdStage, _FinalStage {
        private int id;

        private Optional<Boolean> includeTranslations = Optional.empty();

        private Optional<String> displayAs = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(RetrieveConversationRequest other) {
            id(other.getId());
            displayAs(other.getDisplayAs());
            includeTranslations(other.getIncludeTranslations());
            return this;
        }

        /**
         * <p>The id of the conversation to target</p>
         * <p>The id of the conversation to target</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public _FinalStage id(int id) {
            this.id = id;
            return this;
        }

        /**
         * <p>If set to true, conversation parts will be translated to the detected language of the conversation.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage includeTranslations(Boolean includeTranslations) {
            this.includeTranslations = Optional.ofNullable(includeTranslations);
            return this;
        }

        /**
         * <p>If set to true, conversation parts will be translated to the detected language of the conversation.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "include_translations", nulls = Nulls.SKIP)
        public _FinalStage includeTranslations(Optional<Boolean> includeTranslations) {
            this.includeTranslations = includeTranslations;
            return this;
        }

        /**
         * <p>Set to plaintext to retrieve conversation messages in plain text. This affects both the body and subject fields.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage displayAs(String displayAs) {
            this.displayAs = Optional.ofNullable(displayAs);
            return this;
        }

        /**
         * <p>Set to plaintext to retrieve conversation messages in plain text. This affects both the body and subject fields.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "display_as", nulls = Nulls.SKIP)
        public _FinalStage displayAs(Optional<String> displayAs) {
            this.displayAs = displayAs;
            return this;
        }

        @java.lang.Override
        public RetrieveConversationRequest build() {
            return new RetrieveConversationRequest(id, displayAs, includeTranslations, additionalProperties);
        }
    }
}
