/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.dataevents.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.dataevents.types.LisDataEventsRequestFilter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = LisDataEventsRequest.Builder.class)
public final class LisDataEventsRequest {
    private final LisDataEventsRequestFilter filter;

    private final String type;

    private final Optional<Boolean> summary;

    private final Map<String, Object> additionalProperties;

    private LisDataEventsRequest(
            LisDataEventsRequestFilter filter,
            String type,
            Optional<Boolean> summary,
            Map<String, Object> additionalProperties) {
        this.filter = filter;
        this.type = type;
        this.summary = summary;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("filter")
    public LisDataEventsRequestFilter getFilter() {
        return filter;
    }

    /**
     * @return The value must be user
     */
    @JsonProperty("type")
    public String getType() {
        return type;
    }

    /**
     * @return summary flag
     */
    @JsonProperty("summary")
    public Optional<Boolean> getSummary() {
        return summary;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof LisDataEventsRequest && equalTo((LisDataEventsRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LisDataEventsRequest other) {
        return filter.equals(other.filter) && type.equals(other.type) && summary.equals(other.summary);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.filter, this.type, this.summary);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static FilterStage builder() {
        return new Builder();
    }

    public interface FilterStage {
        TypeStage filter(@NotNull LisDataEventsRequestFilter filter);

        Builder from(LisDataEventsRequest other);
    }

    public interface TypeStage {
        /**
         * <p>The value must be user</p>
         */
        _FinalStage type(@NotNull String type);
    }

    public interface _FinalStage {
        LisDataEventsRequest build();

        /**
         * <p>summary flag</p>
         */
        _FinalStage summary(Optional<Boolean> summary);

        _FinalStage summary(Boolean summary);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements FilterStage, TypeStage, _FinalStage {
        private LisDataEventsRequestFilter filter;

        private String type;

        private Optional<Boolean> summary = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(LisDataEventsRequest other) {
            filter(other.getFilter());
            type(other.getType());
            summary(other.getSummary());
            return this;
        }

        @java.lang.Override
        @JsonSetter("filter")
        public TypeStage filter(@NotNull LisDataEventsRequestFilter filter) {
            this.filter = Objects.requireNonNull(filter, "filter must not be null");
            return this;
        }

        /**
         * <p>The value must be user</p>
         * <p>The value must be user</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("type")
        public _FinalStage type(@NotNull String type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        /**
         * <p>summary flag</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage summary(Boolean summary) {
            this.summary = Optional.ofNullable(summary);
            return this;
        }

        /**
         * <p>summary flag</p>
         */
        @java.lang.Override
        @JsonSetter(value = "summary", nulls = Nulls.SKIP)
        public _FinalStage summary(Optional<Boolean> summary) {
            this.summary = summary;
            return this;
        }

        @java.lang.Override
        public LisDataEventsRequest build() {
            return new LisDataEventsRequest(filter, type, summary, additionalProperties);
        }
    }
}
