/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.emails;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.emails.requests.RetrieveEmailRequest;
import com.intercom.api.resources.unstable.emails.types.EmailList;
import com.intercom.api.resources.unstable.emails.types.EmailSetting;

public class EmailsClient {
    protected final ClientOptions clientOptions;

    private final RawEmailsClient rawClient;

    public EmailsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawEmailsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawEmailsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Lists all sender email address settings for the workspace
     */
    public EmailList listEmails() {
        return this.rawClient.listEmails().body();
    }

    /**
     * Lists all sender email address settings for the workspace
     */
    public EmailList listEmails(RequestOptions requestOptions) {
        return this.rawClient.listEmails(requestOptions).body();
    }

    /**
     * Fetches a specific email setting by its unique identifier
     */
    public EmailSetting retrieveEmail(RetrieveEmailRequest request) {
        return this.rawClient.retrieveEmail(request).body();
    }

    /**
     * Fetches a specific email setting by its unique identifier
     */
    public EmailSetting retrieveEmail(RetrieveEmailRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieveEmail(request, requestOptions).body();
    }
}
