/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.export.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = PostExportReportingDataEnqueueRequest.Builder.class)
public final class PostExportReportingDataEnqueueRequest {
    private final String datasetId;

    private final List<String> attributeIds;

    private final long startTime;

    private final long endTime;

    private final Map<String, Object> additionalProperties;

    private PostExportReportingDataEnqueueRequest(
            String datasetId,
            List<String> attributeIds,
            long startTime,
            long endTime,
            Map<String, Object> additionalProperties) {
        this.datasetId = datasetId;
        this.attributeIds = attributeIds;
        this.startTime = startTime;
        this.endTime = endTime;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("dataset_id")
    public String getDatasetId() {
        return datasetId;
    }

    @JsonProperty("attribute_ids")
    public List<String> getAttributeIds() {
        return attributeIds;
    }

    @JsonProperty("start_time")
    public long getStartTime() {
        return startTime;
    }

    @JsonProperty("end_time")
    public long getEndTime() {
        return endTime;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof PostExportReportingDataEnqueueRequest
                && equalTo((PostExportReportingDataEnqueueRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PostExportReportingDataEnqueueRequest other) {
        return datasetId.equals(other.datasetId)
                && attributeIds.equals(other.attributeIds)
                && startTime == other.startTime
                && endTime == other.endTime;
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.datasetId, this.attributeIds, this.startTime, this.endTime);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static DatasetIdStage builder() {
        return new Builder();
    }

    public interface DatasetIdStage {
        StartTimeStage datasetId(@NotNull String datasetId);

        Builder from(PostExportReportingDataEnqueueRequest other);
    }

    public interface StartTimeStage {
        EndTimeStage startTime(long startTime);
    }

    public interface EndTimeStage {
        _FinalStage endTime(long endTime);
    }

    public interface _FinalStage {
        PostExportReportingDataEnqueueRequest build();

        _FinalStage attributeIds(List<String> attributeIds);

        _FinalStage addAttributeIds(String attributeIds);

        _FinalStage addAllAttributeIds(List<String> attributeIds);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements DatasetIdStage, StartTimeStage, EndTimeStage, _FinalStage {
        private String datasetId;

        private long startTime;

        private long endTime;

        private List<String> attributeIds = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(PostExportReportingDataEnqueueRequest other) {
            datasetId(other.getDatasetId());
            attributeIds(other.getAttributeIds());
            startTime(other.getStartTime());
            endTime(other.getEndTime());
            return this;
        }

        @java.lang.Override
        @JsonSetter("dataset_id")
        public StartTimeStage datasetId(@NotNull String datasetId) {
            this.datasetId = Objects.requireNonNull(datasetId, "datasetId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("start_time")
        public EndTimeStage startTime(long startTime) {
            this.startTime = startTime;
            return this;
        }

        @java.lang.Override
        @JsonSetter("end_time")
        public _FinalStage endTime(long endTime) {
            this.endTime = endTime;
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllAttributeIds(List<String> attributeIds) {
            if (attributeIds != null) {
                this.attributeIds.addAll(attributeIds);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addAttributeIds(String attributeIds) {
            this.attributeIds.add(attributeIds);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "attribute_ids", nulls = Nulls.SKIP)
        public _FinalStage attributeIds(List<String> attributeIds) {
            this.attributeIds.clear();
            if (attributeIds != null) {
                this.attributeIds.addAll(attributeIds);
            }
            return this;
        }

        @java.lang.Override
        public PostExportReportingDataEnqueueRequest build() {
            return new PostExportReportingDataEnqueueRequest(
                    datasetId, attributeIds, startTime, endTime, additionalProperties);
        }
    }
}
