/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.notes;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.notes.requests.CreateNoteRequest;
import com.intercom.api.resources.unstable.notes.requests.ListCompanyNotesRequest;
import com.intercom.api.resources.unstable.notes.requests.ListNotesRequest;
import com.intercom.api.resources.unstable.notes.requests.RetrieveNoteRequest;
import com.intercom.api.resources.unstable.notes.types.Note;
import com.intercom.api.resources.unstable.types.NoteList;
import java.util.concurrent.CompletableFuture;

public class AsyncNotesClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawNotesClient rawClient;

    public AsyncNotesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawNotesClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawNotesClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * You can fetch a list of notes that are associated to a company.
     */
    public CompletableFuture<NoteList> listCompanyNotes(ListCompanyNotesRequest request) {
        return this.rawClient.listCompanyNotes(request).thenApply(response -> response.body());
    }

    /**
     * You can fetch a list of notes that are associated to a company.
     */
    public CompletableFuture<NoteList> listCompanyNotes(
            ListCompanyNotesRequest request, RequestOptions requestOptions) {
        return this.rawClient.listCompanyNotes(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can fetch a list of notes that are associated to a contact.
     */
    public CompletableFuture<NoteList> listNotes(ListNotesRequest request) {
        return this.rawClient.listNotes(request).thenApply(response -> response.body());
    }

    /**
     * You can fetch a list of notes that are associated to a contact.
     */
    public CompletableFuture<NoteList> listNotes(ListNotesRequest request, RequestOptions requestOptions) {
        return this.rawClient.listNotes(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can add a note to a single contact.
     */
    public CompletableFuture<Note> createNote(CreateNoteRequest request) {
        return this.rawClient.createNote(request).thenApply(response -> response.body());
    }

    /**
     * You can add a note to a single contact.
     */
    public CompletableFuture<Note> createNote(CreateNoteRequest request, RequestOptions requestOptions) {
        return this.rawClient.createNote(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can fetch the details of a single note.
     */
    public CompletableFuture<Note> retrieveNote(RetrieveNoteRequest request) {
        return this.rawClient.retrieveNote(request).thenApply(response -> response.body());
    }

    /**
     * You can fetch the details of a single note.
     */
    public CompletableFuture<Note> retrieveNote(RetrieveNoteRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieveNote(request, requestOptions).thenApply(response -> response.body());
    }
}
