/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.tickets.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = UpdateTicketRequest.Builder.class)
public final class UpdateTicketRequest {
    private final String id;

    private final Optional<Map<String, Object>> ticketAttributes;

    private final Optional<String> ticketStateId;

    private final Optional<String> companyId;

    private final Optional<Boolean> open;

    private final Optional<Boolean> isShared;

    private final Optional<Integer> snoozedUntil;

    private final Optional<Integer> adminId;

    private final Optional<String> assigneeId;

    private final Map<String, Object> additionalProperties;

    private UpdateTicketRequest(
            String id,
            Optional<Map<String, Object>> ticketAttributes,
            Optional<String> ticketStateId,
            Optional<String> companyId,
            Optional<Boolean> open,
            Optional<Boolean> isShared,
            Optional<Integer> snoozedUntil,
            Optional<Integer> adminId,
            Optional<String> assigneeId,
            Map<String, Object> additionalProperties) {
        this.id = id;
        this.ticketAttributes = ticketAttributes;
        this.ticketStateId = ticketStateId;
        this.companyId = companyId;
        this.open = open;
        this.isShared = isShared;
        this.snoozedUntil = snoozedUntil;
        this.adminId = adminId;
        this.assigneeId = assigneeId;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The unique identifier for the ticket which is given by Intercom
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    /**
     * @return The attributes set on the ticket.
     */
    @JsonProperty("ticket_attributes")
    public Optional<Map<String, Object>> getTicketAttributes() {
        return ticketAttributes;
    }

    /**
     * @return The ID of the ticket state associated with the ticket type.
     */
    @JsonProperty("ticket_state_id")
    public Optional<String> getTicketStateId() {
        return ticketStateId;
    }

    /**
     * @return The ID of the company that the ticket is associated with. The unique identifier for the company which is given by Intercom. Set to nil to remove company.
     */
    @JsonProperty("company_id")
    public Optional<String> getCompanyId() {
        return companyId;
    }

    /**
     * @return Specify if a ticket is open. Set to false to close a ticket. Closing a ticket will also unsnooze it.
     */
    @JsonProperty("open")
    public Optional<Boolean> getOpen() {
        return open;
    }

    /**
     * @return Specify whether the ticket is visible to users.
     */
    @JsonProperty("is_shared")
    public Optional<Boolean> getIsShared() {
        return isShared;
    }

    /**
     * @return The time you want the ticket to reopen.
     */
    @JsonProperty("snoozed_until")
    public Optional<Integer> getSnoozedUntil() {
        return snoozedUntil;
    }

    /**
     * @return The ID of the admin performing ticket update. Needed for workflows execution and attributing actions to specific admins.
     */
    @JsonProperty("admin_id")
    public Optional<Integer> getAdminId() {
        return adminId;
    }

    /**
     * @return The ID of the admin or team to which the ticket is assigned. Set this 0 to unassign it.
     */
    @JsonProperty("assignee_id")
    public Optional<String> getAssigneeId() {
        return assigneeId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof UpdateTicketRequest && equalTo((UpdateTicketRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateTicketRequest other) {
        return id.equals(other.id)
                && ticketAttributes.equals(other.ticketAttributes)
                && ticketStateId.equals(other.ticketStateId)
                && companyId.equals(other.companyId)
                && open.equals(other.open)
                && isShared.equals(other.isShared)
                && snoozedUntil.equals(other.snoozedUntil)
                && adminId.equals(other.adminId)
                && assigneeId.equals(other.assigneeId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.id,
                this.ticketAttributes,
                this.ticketStateId,
                this.companyId,
                this.open,
                this.isShared,
                this.snoozedUntil,
                this.adminId,
                this.assigneeId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public interface IdStage {
        /**
         * <p>The unique identifier for the ticket which is given by Intercom</p>
         */
        _FinalStage id(@NotNull String id);

        Builder from(UpdateTicketRequest other);
    }

    public interface _FinalStage {
        UpdateTicketRequest build();

        /**
         * <p>The attributes set on the ticket.</p>
         */
        _FinalStage ticketAttributes(Optional<Map<String, Object>> ticketAttributes);

        _FinalStage ticketAttributes(Map<String, Object> ticketAttributes);

        /**
         * <p>The ID of the ticket state associated with the ticket type.</p>
         */
        _FinalStage ticketStateId(Optional<String> ticketStateId);

        _FinalStage ticketStateId(String ticketStateId);

        /**
         * <p>The ID of the company that the ticket is associated with. The unique identifier for the company which is given by Intercom. Set to nil to remove company.</p>
         */
        _FinalStage companyId(Optional<String> companyId);

        _FinalStage companyId(String companyId);

        /**
         * <p>Specify if a ticket is open. Set to false to close a ticket. Closing a ticket will also unsnooze it.</p>
         */
        _FinalStage open(Optional<Boolean> open);

        _FinalStage open(Boolean open);

        /**
         * <p>Specify whether the ticket is visible to users.</p>
         */
        _FinalStage isShared(Optional<Boolean> isShared);

        _FinalStage isShared(Boolean isShared);

        /**
         * <p>The time you want the ticket to reopen.</p>
         */
        _FinalStage snoozedUntil(Optional<Integer> snoozedUntil);

        _FinalStage snoozedUntil(Integer snoozedUntil);

        /**
         * <p>The ID of the admin performing ticket update. Needed for workflows execution and attributing actions to specific admins.</p>
         */
        _FinalStage adminId(Optional<Integer> adminId);

        _FinalStage adminId(Integer adminId);

        /**
         * <p>The ID of the admin or team to which the ticket is assigned. Set this 0 to unassign it.</p>
         */
        _FinalStage assigneeId(Optional<String> assigneeId);

        _FinalStage assigneeId(String assigneeId);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements IdStage, _FinalStage {
        private String id;

        private Optional<String> assigneeId = Optional.empty();

        private Optional<Integer> adminId = Optional.empty();

        private Optional<Integer> snoozedUntil = Optional.empty();

        private Optional<Boolean> isShared = Optional.empty();

        private Optional<Boolean> open = Optional.empty();

        private Optional<String> companyId = Optional.empty();

        private Optional<String> ticketStateId = Optional.empty();

        private Optional<Map<String, Object>> ticketAttributes = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(UpdateTicketRequest other) {
            id(other.getId());
            ticketAttributes(other.getTicketAttributes());
            ticketStateId(other.getTicketStateId());
            companyId(other.getCompanyId());
            open(other.getOpen());
            isShared(other.getIsShared());
            snoozedUntil(other.getSnoozedUntil());
            adminId(other.getAdminId());
            assigneeId(other.getAssigneeId());
            return this;
        }

        /**
         * <p>The unique identifier for the ticket which is given by Intercom</p>
         * <p>The unique identifier for the ticket which is given by Intercom</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        /**
         * <p>The ID of the admin or team to which the ticket is assigned. Set this 0 to unassign it.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage assigneeId(String assigneeId) {
            this.assigneeId = Optional.ofNullable(assigneeId);
            return this;
        }

        /**
         * <p>The ID of the admin or team to which the ticket is assigned. Set this 0 to unassign it.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "assignee_id", nulls = Nulls.SKIP)
        public _FinalStage assigneeId(Optional<String> assigneeId) {
            this.assigneeId = assigneeId;
            return this;
        }

        /**
         * <p>The ID of the admin performing ticket update. Needed for workflows execution and attributing actions to specific admins.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage adminId(Integer adminId) {
            this.adminId = Optional.ofNullable(adminId);
            return this;
        }

        /**
         * <p>The ID of the admin performing ticket update. Needed for workflows execution and attributing actions to specific admins.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "admin_id", nulls = Nulls.SKIP)
        public _FinalStage adminId(Optional<Integer> adminId) {
            this.adminId = adminId;
            return this;
        }

        /**
         * <p>The time you want the ticket to reopen.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage snoozedUntil(Integer snoozedUntil) {
            this.snoozedUntil = Optional.ofNullable(snoozedUntil);
            return this;
        }

        /**
         * <p>The time you want the ticket to reopen.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "snoozed_until", nulls = Nulls.SKIP)
        public _FinalStage snoozedUntil(Optional<Integer> snoozedUntil) {
            this.snoozedUntil = snoozedUntil;
            return this;
        }

        /**
         * <p>Specify whether the ticket is visible to users.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage isShared(Boolean isShared) {
            this.isShared = Optional.ofNullable(isShared);
            return this;
        }

        /**
         * <p>Specify whether the ticket is visible to users.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "is_shared", nulls = Nulls.SKIP)
        public _FinalStage isShared(Optional<Boolean> isShared) {
            this.isShared = isShared;
            return this;
        }

        /**
         * <p>Specify if a ticket is open. Set to false to close a ticket. Closing a ticket will also unsnooze it.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage open(Boolean open) {
            this.open = Optional.ofNullable(open);
            return this;
        }

        /**
         * <p>Specify if a ticket is open. Set to false to close a ticket. Closing a ticket will also unsnooze it.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "open", nulls = Nulls.SKIP)
        public _FinalStage open(Optional<Boolean> open) {
            this.open = open;
            return this;
        }

        /**
         * <p>The ID of the company that the ticket is associated with. The unique identifier for the company which is given by Intercom. Set to nil to remove company.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage companyId(String companyId) {
            this.companyId = Optional.ofNullable(companyId);
            return this;
        }

        /**
         * <p>The ID of the company that the ticket is associated with. The unique identifier for the company which is given by Intercom. Set to nil to remove company.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "company_id", nulls = Nulls.SKIP)
        public _FinalStage companyId(Optional<String> companyId) {
            this.companyId = companyId;
            return this;
        }

        /**
         * <p>The ID of the ticket state associated with the ticket type.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage ticketStateId(String ticketStateId) {
            this.ticketStateId = Optional.ofNullable(ticketStateId);
            return this;
        }

        /**
         * <p>The ID of the ticket state associated with the ticket type.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "ticket_state_id", nulls = Nulls.SKIP)
        public _FinalStage ticketStateId(Optional<String> ticketStateId) {
            this.ticketStateId = ticketStateId;
            return this;
        }

        /**
         * <p>The attributes set on the ticket.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage ticketAttributes(Map<String, Object> ticketAttributes) {
            this.ticketAttributes = Optional.ofNullable(ticketAttributes);
            return this;
        }

        /**
         * <p>The attributes set on the ticket.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "ticket_attributes", nulls = Nulls.SKIP)
        public _FinalStage ticketAttributes(Optional<Map<String, Object>> ticketAttributes) {
            this.ticketAttributes = ticketAttributes;
            return this;
        }

        @java.lang.Override
        public UpdateTicketRequest build() {
            return new UpdateTicketRequest(
                    id,
                    ticketAttributes,
                    ticketStateId,
                    companyId,
                    open,
                    isShared,
                    snoozedUntil,
                    adminId,
                    assigneeId,
                    additionalProperties);
        }
    }
}
