/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ConversationRating.Builder.class)
public final class ConversationRating {
    private final Optional<Integer> rating;

    private final Optional<String> remark;

    private final Optional<Integer> createdAt;

    private final Optional<Integer> updatedAt;

    private final Optional<ContactReference> contact;

    private final Optional<Reference> teammate;

    private final Map<String, Object> additionalProperties;

    private ConversationRating(
            Optional<Integer> rating,
            Optional<String> remark,
            Optional<Integer> createdAt,
            Optional<Integer> updatedAt,
            Optional<ContactReference> contact,
            Optional<Reference> teammate,
            Map<String, Object> additionalProperties) {
        this.rating = rating;
        this.remark = remark;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.contact = contact;
        this.teammate = teammate;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The rating, between 1 and 5, for the conversation.
     */
    @JsonProperty("rating")
    public Optional<Integer> getRating() {
        return rating;
    }

    /**
     * @return An optional field to add a remark to correspond to the number rating
     */
    @JsonProperty("remark")
    public Optional<String> getRemark() {
        return remark;
    }

    /**
     * @return The time the rating was requested in the conversation being rated.
     */
    @JsonProperty("created_at")
    public Optional<Integer> getCreatedAt() {
        return createdAt;
    }

    /**
     * @return The time the rating was last updated.
     */
    @JsonProperty("updated_at")
    public Optional<Integer> getUpdatedAt() {
        return updatedAt;
    }

    @JsonProperty("contact")
    public Optional<ContactReference> getContact() {
        return contact;
    }

    @JsonProperty("teammate")
    public Optional<Reference> getTeammate() {
        return teammate;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ConversationRating && equalTo((ConversationRating) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConversationRating other) {
        return rating.equals(other.rating)
                && remark.equals(other.remark)
                && createdAt.equals(other.createdAt)
                && updatedAt.equals(other.updatedAt)
                && contact.equals(other.contact)
                && teammate.equals(other.teammate);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.rating, this.remark, this.createdAt, this.updatedAt, this.contact, this.teammate);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<Integer> rating = Optional.empty();

        private Optional<String> remark = Optional.empty();

        private Optional<Integer> createdAt = Optional.empty();

        private Optional<Integer> updatedAt = Optional.empty();

        private Optional<ContactReference> contact = Optional.empty();

        private Optional<Reference> teammate = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(ConversationRating other) {
            rating(other.getRating());
            remark(other.getRemark());
            createdAt(other.getCreatedAt());
            updatedAt(other.getUpdatedAt());
            contact(other.getContact());
            teammate(other.getTeammate());
            return this;
        }

        /**
         * <p>The rating, between 1 and 5, for the conversation.</p>
         */
        @JsonSetter(value = "rating", nulls = Nulls.SKIP)
        public Builder rating(Optional<Integer> rating) {
            this.rating = rating;
            return this;
        }

        public Builder rating(Integer rating) {
            this.rating = Optional.ofNullable(rating);
            return this;
        }

        /**
         * <p>An optional field to add a remark to correspond to the number rating</p>
         */
        @JsonSetter(value = "remark", nulls = Nulls.SKIP)
        public Builder remark(Optional<String> remark) {
            this.remark = remark;
            return this;
        }

        public Builder remark(String remark) {
            this.remark = Optional.ofNullable(remark);
            return this;
        }

        /**
         * <p>The time the rating was requested in the conversation being rated.</p>
         */
        @JsonSetter(value = "created_at", nulls = Nulls.SKIP)
        public Builder createdAt(Optional<Integer> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(Integer createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        /**
         * <p>The time the rating was last updated.</p>
         */
        @JsonSetter(value = "updated_at", nulls = Nulls.SKIP)
        public Builder updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @JsonSetter(value = "contact", nulls = Nulls.SKIP)
        public Builder contact(Optional<ContactReference> contact) {
            this.contact = contact;
            return this;
        }

        public Builder contact(ContactReference contact) {
            this.contact = Optional.ofNullable(contact);
            return this;
        }

        @JsonSetter(value = "teammate", nulls = Nulls.SKIP)
        public Builder teammate(Optional<Reference> teammate) {
            this.teammate = teammate;
            return this;
        }

        public Builder teammate(Reference teammate) {
            this.teammate = Optional.ofNullable(teammate);
            return this;
        }

        public ConversationRating build() {
            return new ConversationRating(
                    rating, remark, createdAt, updatedAt, contact, teammate, additionalProperties);
        }
    }
}
