/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ConversationSlaTargetMissed.Builder.class)
public final class ConversationSlaTargetMissed {
    private final Optional<String> slaName;

    private final Optional<SlaTargetType> slaTargetType;

    private final Optional<CurrentSlaStatus> currentSlaStatus;

    private final Optional<Map<String, SlaStatesValue>> slaStates;

    private final Map<String, Object> additionalProperties;

    private ConversationSlaTargetMissed(
            Optional<String> slaName,
            Optional<SlaTargetType> slaTargetType,
            Optional<CurrentSlaStatus> currentSlaStatus,
            Optional<Map<String, SlaStatesValue>> slaStates,
            Map<String, Object> additionalProperties) {
        this.slaName = slaName;
        this.slaTargetType = slaTargetType;
        this.currentSlaStatus = currentSlaStatus;
        this.slaStates = slaStates;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Name of the SLA
     */
    @JsonProperty("sla_name")
    public Optional<String> getSlaName() {
        return slaName;
    }

    /**
     * @return Which specific target was missed
     */
    @JsonProperty("sla_target_type")
    public Optional<SlaTargetType> getSlaTargetType() {
        return slaTargetType;
    }

    /**
     * @return Overall SLA status
     */
    @JsonProperty("current_sla_status")
    public Optional<CurrentSlaStatus> getCurrentSlaStatus() {
        return currentSlaStatus;
    }

    /**
     * @return Status of all SLA targets at the time of breach
     */
    @JsonProperty("sla_states")
    public Optional<Map<String, SlaStatesValue>> getSlaStates() {
        return slaStates;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ConversationSlaTargetMissed && equalTo((ConversationSlaTargetMissed) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConversationSlaTargetMissed other) {
        return slaName.equals(other.slaName)
                && slaTargetType.equals(other.slaTargetType)
                && currentSlaStatus.equals(other.currentSlaStatus)
                && slaStates.equals(other.slaStates);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.slaName, this.slaTargetType, this.currentSlaStatus, this.slaStates);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> slaName = Optional.empty();

        private Optional<SlaTargetType> slaTargetType = Optional.empty();

        private Optional<CurrentSlaStatus> currentSlaStatus = Optional.empty();

        private Optional<Map<String, SlaStatesValue>> slaStates = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(ConversationSlaTargetMissed other) {
            slaName(other.getSlaName());
            slaTargetType(other.getSlaTargetType());
            currentSlaStatus(other.getCurrentSlaStatus());
            slaStates(other.getSlaStates());
            return this;
        }

        /**
         * <p>Name of the SLA</p>
         */
        @JsonSetter(value = "sla_name", nulls = Nulls.SKIP)
        public Builder slaName(Optional<String> slaName) {
            this.slaName = slaName;
            return this;
        }

        public Builder slaName(String slaName) {
            this.slaName = Optional.ofNullable(slaName);
            return this;
        }

        /**
         * <p>Which specific target was missed</p>
         */
        @JsonSetter(value = "sla_target_type", nulls = Nulls.SKIP)
        public Builder slaTargetType(Optional<SlaTargetType> slaTargetType) {
            this.slaTargetType = slaTargetType;
            return this;
        }

        public Builder slaTargetType(SlaTargetType slaTargetType) {
            this.slaTargetType = Optional.ofNullable(slaTargetType);
            return this;
        }

        /**
         * <p>Overall SLA status</p>
         */
        @JsonSetter(value = "current_sla_status", nulls = Nulls.SKIP)
        public Builder currentSlaStatus(Optional<CurrentSlaStatus> currentSlaStatus) {
            this.currentSlaStatus = currentSlaStatus;
            return this;
        }

        public Builder currentSlaStatus(CurrentSlaStatus currentSlaStatus) {
            this.currentSlaStatus = Optional.ofNullable(currentSlaStatus);
            return this;
        }

        /**
         * <p>Status of all SLA targets at the time of breach</p>
         */
        @JsonSetter(value = "sla_states", nulls = Nulls.SKIP)
        public Builder slaStates(Optional<Map<String, SlaStatesValue>> slaStates) {
            this.slaStates = slaStates;
            return this;
        }

        public Builder slaStates(Map<String, SlaStatesValue> slaStates) {
            this.slaStates = Optional.ofNullable(slaStates);
            return this;
        }

        public ConversationSlaTargetMissed build() {
            return new ConversationSlaTargetMissed(
                    slaName, slaTargetType, currentSlaStatus, slaStates, additionalProperties);
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = SlaStatesValue.Builder.class)
    public static final class SlaStatesValue {
        private final Optional<Status> status;

        private final Optional<Integer> secondsRemaining;

        private final Map<String, Object> additionalProperties;

        private SlaStatesValue(
                Optional<Status> status, Optional<Integer> secondsRemaining, Map<String, Object> additionalProperties) {
            this.status = status;
            this.secondsRemaining = secondsRemaining;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return Status of this specific target
         */
        @JsonProperty("status")
        public Optional<Status> getStatus() {
            return status;
        }

        /**
         * @return Time remaining for active/paused targets (null for hit/missed)
         */
        @JsonProperty("seconds_remaining")
        public Optional<Integer> getSecondsRemaining() {
            return secondsRemaining;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof SlaStatesValue && equalTo((SlaStatesValue) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(SlaStatesValue other) {
            return status.equals(other.status) && secondsRemaining.equals(other.secondsRemaining);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.status, this.secondsRemaining);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder {
            private Optional<Status> status = Optional.empty();

            private Optional<Integer> secondsRemaining = Optional.empty();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            public Builder from(SlaStatesValue other) {
                status(other.getStatus());
                secondsRemaining(other.getSecondsRemaining());
                return this;
            }

            /**
             * <p>Status of this specific target</p>
             */
            @JsonSetter(value = "status", nulls = Nulls.SKIP)
            public Builder status(Optional<Status> status) {
                this.status = status;
                return this;
            }

            public Builder status(Status status) {
                this.status = Optional.ofNullable(status);
                return this;
            }

            /**
             * <p>Time remaining for active/paused targets (null for hit/missed)</p>
             */
            @JsonSetter(value = "seconds_remaining", nulls = Nulls.SKIP)
            public Builder secondsRemaining(Optional<Integer> secondsRemaining) {
                this.secondsRemaining = secondsRemaining;
                return this;
            }

            public Builder secondsRemaining(Integer secondsRemaining) {
                this.secondsRemaining = Optional.ofNullable(secondsRemaining);
                return this;
            }

            public SlaStatesValue build() {
                return new SlaStatesValue(status, secondsRemaining, additionalProperties);
            }
        }

        public static final class Status {
            public static final Status HIT = new Status(Value.HIT, "hit");

            public static final Status PAUSED = new Status(Value.PAUSED, "paused");

            public static final Status ACTIVE = new Status(Value.ACTIVE, "active");

            public static final Status MISSED = new Status(Value.MISSED, "missed");

            private final Value value;

            private final String string;

            Status(Value value, String string) {
                this.value = value;
                this.string = string;
            }

            public Value getEnumValue() {
                return value;
            }

            @java.lang.Override
            @JsonValue
            public String toString() {
                return this.string;
            }

            @java.lang.Override
            public boolean equals(Object other) {
                return (this == other) || (other instanceof Status && this.string.equals(((Status) other).string));
            }

            @java.lang.Override
            public int hashCode() {
                return this.string.hashCode();
            }

            public <T> T visit(Visitor<T> visitor) {
                switch (value) {
                    case HIT:
                        return visitor.visitHit();
                    case PAUSED:
                        return visitor.visitPaused();
                    case ACTIVE:
                        return visitor.visitActive();
                    case MISSED:
                        return visitor.visitMissed();
                    case UNKNOWN:
                    default:
                        return visitor.visitUnknown(string);
                }
            }

            @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
            public static Status valueOf(String value) {
                switch (value) {
                    case "hit":
                        return HIT;
                    case "paused":
                        return PAUSED;
                    case "active":
                        return ACTIVE;
                    case "missed":
                        return MISSED;
                    default:
                        return new Status(Value.UNKNOWN, value);
                }
            }

            public enum Value {
                HIT,

                MISSED,

                ACTIVE,

                PAUSED,

                UNKNOWN
            }

            public interface Visitor<T> {
                T visitHit();

                T visitMissed();

                T visitActive();

                T visitPaused();

                T visitUnknown(String unknownType);
            }
        }
    }

    public static final class SlaTargetType {
        public static final SlaTargetType NEXT_REPLY_TIME = new SlaTargetType(Value.NEXT_REPLY_TIME, "next_reply_time");

        public static final SlaTargetType RESOLUTION_TIME = new SlaTargetType(Value.RESOLUTION_TIME, "resolution_time");

        public static final SlaTargetType FIRST_REPLY_TIME =
                new SlaTargetType(Value.FIRST_REPLY_TIME, "first_reply_time");

        public static final SlaTargetType TIME_TO_CLOSE = new SlaTargetType(Value.TIME_TO_CLOSE, "time_to_close");

        private final Value value;

        private final String string;

        SlaTargetType(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other)
                    || (other instanceof SlaTargetType && this.string.equals(((SlaTargetType) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case NEXT_REPLY_TIME:
                    return visitor.visitNextReplyTime();
                case RESOLUTION_TIME:
                    return visitor.visitResolutionTime();
                case FIRST_REPLY_TIME:
                    return visitor.visitFirstReplyTime();
                case TIME_TO_CLOSE:
                    return visitor.visitTimeToClose();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static SlaTargetType valueOf(String value) {
            switch (value) {
                case "next_reply_time":
                    return NEXT_REPLY_TIME;
                case "resolution_time":
                    return RESOLUTION_TIME;
                case "first_reply_time":
                    return FIRST_REPLY_TIME;
                case "time_to_close":
                    return TIME_TO_CLOSE;
                default:
                    return new SlaTargetType(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            FIRST_REPLY_TIME,

            NEXT_REPLY_TIME,

            RESOLUTION_TIME,

            TIME_TO_CLOSE,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitFirstReplyTime();

            T visitNextReplyTime();

            T visitResolutionTime();

            T visitTimeToClose();

            T visitUnknown(String unknownType);
        }
    }

    public static final class CurrentSlaStatus {
        public static final CurrentSlaStatus HIT = new CurrentSlaStatus(Value.HIT, "hit");

        public static final CurrentSlaStatus CANCELED = new CurrentSlaStatus(Value.CANCELED, "canceled");

        public static final CurrentSlaStatus PAUSED = new CurrentSlaStatus(Value.PAUSED, "paused");

        public static final CurrentSlaStatus ACTIVE = new CurrentSlaStatus(Value.ACTIVE, "active");

        public static final CurrentSlaStatus MISSED = new CurrentSlaStatus(Value.MISSED, "missed");

        private final Value value;

        private final String string;

        CurrentSlaStatus(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other)
                    || (other instanceof CurrentSlaStatus && this.string.equals(((CurrentSlaStatus) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case HIT:
                    return visitor.visitHit();
                case CANCELED:
                    return visitor.visitCanceled();
                case PAUSED:
                    return visitor.visitPaused();
                case ACTIVE:
                    return visitor.visitActive();
                case MISSED:
                    return visitor.visitMissed();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static CurrentSlaStatus valueOf(String value) {
            switch (value) {
                case "hit":
                    return HIT;
                case "canceled":
                    return CANCELED;
                case "paused":
                    return PAUSED;
                case "active":
                    return ACTIVE;
                case "missed":
                    return MISSED;
                default:
                    return new CurrentSlaStatus(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            HIT,

            MISSED,

            ACTIVE,

            PAUSED,

            CANCELED,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitHit();

            T visitMissed();

            T visitActive();

            T visitPaused();

            T visitCanceled();

            T visitUnknown(String unknownType);
        }
    }
}
