/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ConversationSlaUnpaused.Builder.class)
public final class ConversationSlaUnpaused {
    private final Optional<String> slaName;

    private final Map<String, Object> additionalProperties;

    private ConversationSlaUnpaused(Optional<String> slaName, Map<String, Object> additionalProperties) {
        this.slaName = slaName;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Name of the SLA being unpaused
     */
    @JsonProperty("sla_name")
    public Optional<String> getSlaName() {
        return slaName;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ConversationSlaUnpaused && equalTo((ConversationSlaUnpaused) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConversationSlaUnpaused other) {
        return slaName.equals(other.slaName);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.slaName);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> slaName = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(ConversationSlaUnpaused other) {
            slaName(other.getSlaName());
            return this;
        }

        /**
         * <p>Name of the SLA being unpaused</p>
         */
        @JsonSetter(value = "sla_name", nulls = Nulls.SKIP)
        public Builder slaName(Optional<String> slaName) {
            this.slaName = slaName;
            return this;
        }

        public Builder slaName(String slaName) {
            this.slaName = Optional.ofNullable(slaName);
            return this;
        }

        public ConversationSlaUnpaused build() {
            return new ConversationSlaUnpaused(slaName, additionalProperties);
        }
    }
}
