/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ConversationTagsUpdated.Builder.class)
public final class ConversationTagsUpdated {
    private final Optional<List<String>> tagsAdded;

    private final Optional<List<String>> tagsRemoved;

    private final Map<String, Object> additionalProperties;

    private ConversationTagsUpdated(
            Optional<List<String>> tagsAdded,
            Optional<List<String>> tagsRemoved,
            Map<String, Object> additionalProperties) {
        this.tagsAdded = tagsAdded;
        this.tagsRemoved = tagsRemoved;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Array of tag names that were added
     */
    @JsonProperty("tags_added")
    public Optional<List<String>> getTagsAdded() {
        return tagsAdded;
    }

    /**
     * @return Array of tag names that were removed
     */
    @JsonProperty("tags_removed")
    public Optional<List<String>> getTagsRemoved() {
        return tagsRemoved;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ConversationTagsUpdated && equalTo((ConversationTagsUpdated) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConversationTagsUpdated other) {
        return tagsAdded.equals(other.tagsAdded) && tagsRemoved.equals(other.tagsRemoved);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.tagsAdded, this.tagsRemoved);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<List<String>> tagsAdded = Optional.empty();

        private Optional<List<String>> tagsRemoved = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(ConversationTagsUpdated other) {
            tagsAdded(other.getTagsAdded());
            tagsRemoved(other.getTagsRemoved());
            return this;
        }

        /**
         * <p>Array of tag names that were added</p>
         */
        @JsonSetter(value = "tags_added", nulls = Nulls.SKIP)
        public Builder tagsAdded(Optional<List<String>> tagsAdded) {
            this.tagsAdded = tagsAdded;
            return this;
        }

        public Builder tagsAdded(List<String> tagsAdded) {
            this.tagsAdded = Optional.ofNullable(tagsAdded);
            return this;
        }

        /**
         * <p>Array of tag names that were removed</p>
         */
        @JsonSetter(value = "tags_removed", nulls = Nulls.SKIP)
        public Builder tagsRemoved(Optional<List<String>> tagsRemoved) {
            this.tagsRemoved = tagsRemoved;
            return this;
        }

        public Builder tagsRemoved(List<String> tagsRemoved) {
            this.tagsRemoved = Optional.ofNullable(tagsRemoved);
            return this;
        }

        public ConversationTagsUpdated build() {
            return new ConversationTagsUpdated(tagsAdded, tagsRemoved, additionalProperties);
        }
    }
}
