/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CreateOrUpdateTagRequest.Builder.class)
public final class CreateOrUpdateTagRequest {
    private final String name;

    private final Optional<String> id;

    private final Map<String, Object> additionalProperties;

    private CreateOrUpdateTagRequest(String name, Optional<String> id, Map<String, Object> additionalProperties) {
        this.name = name;
        this.id = id;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The name of the tag, which will be created if not found, or the new name for the tag if this is an update request. Names are case insensitive.
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * @return The id of tag to updates.
     */
    @JsonProperty("id")
    public Optional<String> getId() {
        return id;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CreateOrUpdateTagRequest && equalTo((CreateOrUpdateTagRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateOrUpdateTagRequest other) {
        return name.equals(other.name) && id.equals(other.id);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.name, this.id);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    public interface NameStage {
        /**
         * <p>The name of the tag, which will be created if not found, or the new name for the tag if this is an update request. Names are case insensitive.</p>
         */
        _FinalStage name(@NotNull String name);

        Builder from(CreateOrUpdateTagRequest other);
    }

    public interface _FinalStage {
        CreateOrUpdateTagRequest build();

        /**
         * <p>The id of tag to updates.</p>
         */
        _FinalStage id(Optional<String> id);

        _FinalStage id(String id);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements NameStage, _FinalStage {
        private String name;

        private Optional<String> id = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CreateOrUpdateTagRequest other) {
            name(other.getName());
            id(other.getId());
            return this;
        }

        /**
         * <p>The name of the tag, which will be created if not found, or the new name for the tag if this is an update request. Names are case insensitive.</p>
         * <p>The name of the tag, which will be created if not found, or the new name for the tag if this is an update request. Names are case insensitive.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("name")
        public _FinalStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        /**
         * <p>The id of tag to updates.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        /**
         * <p>The id of tag to updates.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "id", nulls = Nulls.SKIP)
        public _FinalStage id(Optional<String> id) {
            this.id = id;
            return this;
        }

        @java.lang.Override
        public CreateOrUpdateTagRequest build() {
            return new CreateOrUpdateTagRequest(name, id, additionalProperties);
        }
    }
}
