/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = HandlingEvent.Builder.class)
public final class HandlingEvent {
    private final TeammateReference teammate;

    private final Type type;

    private final OffsetDateTime timestamp;

    private final Optional<String> reason;

    private final Map<String, Object> additionalProperties;

    private HandlingEvent(
            TeammateReference teammate,
            Type type,
            OffsetDateTime timestamp,
            Optional<String> reason,
            Map<String, Object> additionalProperties) {
        this.teammate = teammate;
        this.type = type;
        this.timestamp = timestamp;
        this.reason = reason;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("teammate")
    public TeammateReference getTeammate() {
        return teammate;
    }

    /**
     * @return The type of handling event
     */
    @JsonProperty("type")
    public Type getType() {
        return type;
    }

    /**
     * @return ISO8601 timestamp when the event occurred
     */
    @JsonProperty("timestamp")
    public OffsetDateTime getTimestamp() {
        return timestamp;
    }

    /**
     * @return Optional reason for the event (e.g., &quot;Paused&quot;, &quot;Away&quot;)
     */
    @JsonProperty("reason")
    public Optional<String> getReason() {
        return reason;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof HandlingEvent && equalTo((HandlingEvent) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(HandlingEvent other) {
        return teammate.equals(other.teammate)
                && type.equals(other.type)
                && timestamp.equals(other.timestamp)
                && reason.equals(other.reason);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.teammate, this.type, this.timestamp, this.reason);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TeammateStage builder() {
        return new Builder();
    }

    public interface TeammateStage {
        TypeStage teammate(@NotNull TeammateReference teammate);

        Builder from(HandlingEvent other);
    }

    public interface TypeStage {
        /**
         * <p>The type of handling event</p>
         */
        TimestampStage type(@NotNull Type type);
    }

    public interface TimestampStage {
        /**
         * <p>ISO8601 timestamp when the event occurred</p>
         */
        _FinalStage timestamp(@NotNull OffsetDateTime timestamp);
    }

    public interface _FinalStage {
        HandlingEvent build();

        /**
         * <p>Optional reason for the event (e.g., &quot;Paused&quot;, &quot;Away&quot;)</p>
         */
        _FinalStage reason(Optional<String> reason);

        _FinalStage reason(String reason);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TeammateStage, TypeStage, TimestampStage, _FinalStage {
        private TeammateReference teammate;

        private Type type;

        private OffsetDateTime timestamp;

        private Optional<String> reason = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(HandlingEvent other) {
            teammate(other.getTeammate());
            type(other.getType());
            timestamp(other.getTimestamp());
            reason(other.getReason());
            return this;
        }

        @java.lang.Override
        @JsonSetter("teammate")
        public TypeStage teammate(@NotNull TeammateReference teammate) {
            this.teammate = Objects.requireNonNull(teammate, "teammate must not be null");
            return this;
        }

        /**
         * <p>The type of handling event</p>
         * <p>The type of handling event</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("type")
        public TimestampStage type(@NotNull Type type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        /**
         * <p>ISO8601 timestamp when the event occurred</p>
         * <p>ISO8601 timestamp when the event occurred</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("timestamp")
        public _FinalStage timestamp(@NotNull OffsetDateTime timestamp) {
            this.timestamp = Objects.requireNonNull(timestamp, "timestamp must not be null");
            return this;
        }

        /**
         * <p>Optional reason for the event (e.g., &quot;Paused&quot;, &quot;Away&quot;)</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage reason(String reason) {
            this.reason = Optional.ofNullable(reason);
            return this;
        }

        /**
         * <p>Optional reason for the event (e.g., &quot;Paused&quot;, &quot;Away&quot;)</p>
         */
        @java.lang.Override
        @JsonSetter(value = "reason", nulls = Nulls.SKIP)
        public _FinalStage reason(Optional<String> reason) {
            this.reason = reason;
            return this;
        }

        @java.lang.Override
        public HandlingEvent build() {
            return new HandlingEvent(teammate, type, timestamp, reason, additionalProperties);
        }
    }

    public static final class Type {
        public static final Type RESUMED = new Type(Value.RESUMED, "resumed");

        public static final Type PAUSED = new Type(Value.PAUSED, "paused");

        private final Value value;

        private final String string;

        Type(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other) || (other instanceof Type && this.string.equals(((Type) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case RESUMED:
                    return visitor.visitResumed();
                case PAUSED:
                    return visitor.visitPaused();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static Type valueOf(String value) {
            switch (value) {
                case "resumed":
                    return RESUMED;
                case "paused":
                    return PAUSED;
                default:
                    return new Type(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            PAUSED,

            RESUMED,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitPaused();

            T visitResumed();

            T visitUnknown(String unknownType);
        }
    }
}
