/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public final class RedactConversationRequest {
    private final Value value;

    @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
    private RedactConversationRequest(Value value) {
        this.value = value;
    }

    public <T> T visit(Visitor<T> visitor) {
        return value.visit(visitor);
    }

    public static RedactConversationRequest conversationPart(ConversationPart value) {
        return new RedactConversationRequest(new ConversationPartValue(value));
    }

    public static RedactConversationRequest source(Source value) {
        return new RedactConversationRequest(new SourceValue(value));
    }

    public boolean isConversationPart() {
        return value instanceof ConversationPartValue;
    }

    public boolean isSource() {
        return value instanceof SourceValue;
    }

    public boolean _isUnknown() {
        return value instanceof _UnknownValue;
    }

    public Optional<ConversationPart> getConversationPart() {
        if (isConversationPart()) {
            return Optional.of(((ConversationPartValue) value).value);
        }
        return Optional.empty();
    }

    public Optional<Source> getSource() {
        if (isSource()) {
            return Optional.of(((SourceValue) value).value);
        }
        return Optional.empty();
    }

    public Optional<Object> _getUnknown() {
        if (_isUnknown()) {
            return Optional.of(((_UnknownValue) value).value);
        }
        return Optional.empty();
    }

    @JsonValue
    private Value getValue() {
        return this.value;
    }

    public interface Visitor<T> {
        T visitConversationPart(ConversationPart conversationPart);

        T visitSource(Source source);

        T _visitUnknown(Object unknownType);
    }

    @JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "type", visible = true, defaultImpl = _UnknownValue.class)
    @JsonSubTypes({@JsonSubTypes.Type(ConversationPartValue.class), @JsonSubTypes.Type(SourceValue.class)})
    @JsonIgnoreProperties(ignoreUnknown = true)
    private interface Value {
        <T> T visit(Visitor<T> visitor);
    }

    @JsonTypeName("conversation_part")
    @JsonIgnoreProperties("type")
    private static final class ConversationPartValue implements Value {
        @JsonUnwrapped
        private ConversationPart value;

        @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
        private ConversationPartValue() {}

        private ConversationPartValue(ConversationPart value) {
            this.value = value;
        }

        @java.lang.Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitConversationPart(value);
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof ConversationPartValue && equalTo((ConversationPartValue) other);
        }

        private boolean equalTo(ConversationPartValue other) {
            return value.equals(other.value);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.value);
        }

        @java.lang.Override
        public String toString() {
            return "RedactConversationRequest{" + "value: " + value + "}";
        }
    }

    @JsonTypeName("source")
    @JsonIgnoreProperties("type")
    private static final class SourceValue implements Value {
        @JsonUnwrapped
        private Source value;

        @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
        private SourceValue() {}

        private SourceValue(Source value) {
            this.value = value;
        }

        @java.lang.Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitSource(value);
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof SourceValue && equalTo((SourceValue) other);
        }

        private boolean equalTo(SourceValue other) {
            return value.equals(other.value);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.value);
        }

        @java.lang.Override
        public String toString() {
            return "RedactConversationRequest{" + "value: " + value + "}";
        }
    }

    @JsonIgnoreProperties("type")
    private static final class _UnknownValue implements Value {
        private String type;

        @JsonValue
        private Object value;

        @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
        private _UnknownValue(@JsonProperty("value") Object value) {}

        @java.lang.Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor._visitUnknown(value);
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof _UnknownValue && equalTo((_UnknownValue) other);
        }

        private boolean equalTo(_UnknownValue other) {
            return type.equals(other.type) && value.equals(other.value);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.type, this.value);
        }

        @java.lang.Override
        public String toString() {
            return "RedactConversationRequest{" + "type: " + type + ", value: " + value + "}";
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = ConversationPart.Builder.class)
    public static final class ConversationPart {
        private final String conversationId;

        private final String conversationPartId;

        private final Map<String, Object> additionalProperties;

        private ConversationPart(
                String conversationId, String conversationPartId, Map<String, Object> additionalProperties) {
            this.conversationId = conversationId;
            this.conversationPartId = conversationPartId;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return The id of the conversation.
         */
        @JsonProperty("conversation_id")
        public String getConversationId() {
            return conversationId;
        }

        /**
         * @return The id of the conversation_part.
         */
        @JsonProperty("conversation_part_id")
        public String getConversationPartId() {
            return conversationPartId;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof ConversationPart && equalTo((ConversationPart) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(ConversationPart other) {
            return conversationId.equals(other.conversationId) && conversationPartId.equals(other.conversationPartId);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.conversationId, this.conversationPartId);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static ConversationIdStage builder() {
            return new Builder();
        }

        public interface ConversationIdStage {
            /**
             * <p>The id of the conversation.</p>
             */
            ConversationPartIdStage conversationId(@NotNull String conversationId);

            Builder from(ConversationPart other);
        }

        public interface ConversationPartIdStage {
            /**
             * <p>The id of the conversation_part.</p>
             */
            _FinalStage conversationPartId(@NotNull String conversationPartId);
        }

        public interface _FinalStage {
            ConversationPart build();
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder implements ConversationIdStage, ConversationPartIdStage, _FinalStage {
            private String conversationId;

            private String conversationPartId;

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            @java.lang.Override
            public Builder from(ConversationPart other) {
                conversationId(other.getConversationId());
                conversationPartId(other.getConversationPartId());
                return this;
            }

            /**
             * <p>The id of the conversation.</p>
             * <p>The id of the conversation.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("conversation_id")
            public ConversationPartIdStage conversationId(@NotNull String conversationId) {
                this.conversationId = Objects.requireNonNull(conversationId, "conversationId must not be null");
                return this;
            }

            /**
             * <p>The id of the conversation_part.</p>
             * <p>The id of the conversation_part.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("conversation_part_id")
            public _FinalStage conversationPartId(@NotNull String conversationPartId) {
                this.conversationPartId =
                        Objects.requireNonNull(conversationPartId, "conversationPartId must not be null");
                return this;
            }

            @java.lang.Override
            public ConversationPart build() {
                return new ConversationPart(conversationId, conversationPartId, additionalProperties);
            }
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = Source.Builder.class)
    public static final class Source {
        private final String conversationId;

        private final String sourceId;

        private final Map<String, Object> additionalProperties;

        private Source(String conversationId, String sourceId, Map<String, Object> additionalProperties) {
            this.conversationId = conversationId;
            this.sourceId = sourceId;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return The id of the conversation.
         */
        @JsonProperty("conversation_id")
        public String getConversationId() {
            return conversationId;
        }

        /**
         * @return The id of the source.
         */
        @JsonProperty("source_id")
        public String getSourceId() {
            return sourceId;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof Source && equalTo((Source) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Source other) {
            return conversationId.equals(other.conversationId) && sourceId.equals(other.sourceId);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.conversationId, this.sourceId);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static ConversationIdStage builder() {
            return new Builder();
        }

        public interface ConversationIdStage {
            /**
             * <p>The id of the conversation.</p>
             */
            SourceIdStage conversationId(@NotNull String conversationId);

            Builder from(Source other);
        }

        public interface SourceIdStage {
            /**
             * <p>The id of the source.</p>
             */
            _FinalStage sourceId(@NotNull String sourceId);
        }

        public interface _FinalStage {
            Source build();
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder implements ConversationIdStage, SourceIdStage, _FinalStage {
            private String conversationId;

            private String sourceId;

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            @java.lang.Override
            public Builder from(Source other) {
                conversationId(other.getConversationId());
                sourceId(other.getSourceId());
                return this;
            }

            /**
             * <p>The id of the conversation.</p>
             * <p>The id of the conversation.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("conversation_id")
            public SourceIdStage conversationId(@NotNull String conversationId) {
                this.conversationId = Objects.requireNonNull(conversationId, "conversationId must not be null");
                return this;
            }

            /**
             * <p>The id of the source.</p>
             * <p>The id of the source.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("source_id")
            public _FinalStage sourceId(@NotNull String sourceId) {
                this.sourceId = Objects.requireNonNull(sourceId, "sourceId must not be null");
                return this;
            }

            @java.lang.Override
            public Source build() {
                return new Source(conversationId, sourceId, additionalProperties);
            }
        }
    }
}
