/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.segments.types.Segment;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = SegmentList.Builder.class)
public final class SegmentList {
    private final Optional<String> type;

    private final Optional<List<Segment>> segments;

    private final Optional<Map<String, Object>> pages;

    private final Map<String, Object> additionalProperties;

    private SegmentList(
            Optional<String> type,
            Optional<List<Segment>> segments,
            Optional<Map<String, Object>> pages,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.segments = segments;
        this.pages = pages;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of the object
     */
    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    /**
     * @return A list of Segment objects
     */
    @JsonProperty("segments")
    public Optional<List<Segment>> getSegments() {
        return segments;
    }

    /**
     * @return A pagination object, which may be empty, indicating no further pages to fetch.
     */
    @JsonProperty("pages")
    public Optional<Map<String, Object>> getPages() {
        return pages;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof SegmentList && equalTo((SegmentList) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SegmentList other) {
        return type.equals(other.type) && segments.equals(other.segments) && pages.equals(other.pages);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.type, this.segments, this.pages);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();

        private Optional<List<Segment>> segments = Optional.empty();

        private Optional<Map<String, Object>> pages = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(SegmentList other) {
            type(other.getType());
            segments(other.getSegments());
            pages(other.getPages());
            return this;
        }

        /**
         * <p>The type of the object</p>
         */
        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * <p>A list of Segment objects</p>
         */
        @JsonSetter(value = "segments", nulls = Nulls.SKIP)
        public Builder segments(Optional<List<Segment>> segments) {
            this.segments = segments;
            return this;
        }

        public Builder segments(List<Segment> segments) {
            this.segments = Optional.ofNullable(segments);
            return this;
        }

        /**
         * <p>A pagination object, which may be empty, indicating no further pages to fetch.</p>
         */
        @JsonSetter(value = "pages", nulls = Nulls.SKIP)
        public Builder pages(Optional<Map<String, Object>> pages) {
            this.pages = pages;
            return this;
        }

        public Builder pages(Map<String, Object> pages) {
            this.pages = Optional.ofNullable(pages);
            return this;
        }

        public SegmentList build() {
            return new SegmentList(type, segments, pages, additionalProperties);
        }
    }
}
