/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = TeamPriorityLevel.Builder.class)
public final class TeamPriorityLevel {
    private final Optional<List<Integer>> primaryTeamIds;

    private final Optional<List<Integer>> secondaryTeamIds;

    private final Map<String, Object> additionalProperties;

    private TeamPriorityLevel(
            Optional<List<Integer>> primaryTeamIds,
            Optional<List<Integer>> secondaryTeamIds,
            Map<String, Object> additionalProperties) {
        this.primaryTeamIds = primaryTeamIds;
        this.secondaryTeamIds = secondaryTeamIds;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The primary team ids for the team
     */
    @JsonProperty("primary_team_ids")
    public Optional<List<Integer>> getPrimaryTeamIds() {
        return primaryTeamIds;
    }

    /**
     * @return The secondary team ids for the team
     */
    @JsonProperty("secondary_team_ids")
    public Optional<List<Integer>> getSecondaryTeamIds() {
        return secondaryTeamIds;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof TeamPriorityLevel && equalTo((TeamPriorityLevel) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TeamPriorityLevel other) {
        return primaryTeamIds.equals(other.primaryTeamIds) && secondaryTeamIds.equals(other.secondaryTeamIds);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.primaryTeamIds, this.secondaryTeamIds);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<List<Integer>> primaryTeamIds = Optional.empty();

        private Optional<List<Integer>> secondaryTeamIds = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(TeamPriorityLevel other) {
            primaryTeamIds(other.getPrimaryTeamIds());
            secondaryTeamIds(other.getSecondaryTeamIds());
            return this;
        }

        /**
         * <p>The primary team ids for the team</p>
         */
        @JsonSetter(value = "primary_team_ids", nulls = Nulls.SKIP)
        public Builder primaryTeamIds(Optional<List<Integer>> primaryTeamIds) {
            this.primaryTeamIds = primaryTeamIds;
            return this;
        }

        public Builder primaryTeamIds(List<Integer> primaryTeamIds) {
            this.primaryTeamIds = Optional.ofNullable(primaryTeamIds);
            return this;
        }

        /**
         * <p>The secondary team ids for the team</p>
         */
        @JsonSetter(value = "secondary_team_ids", nulls = Nulls.SKIP)
        public Builder secondaryTeamIds(Optional<List<Integer>> secondaryTeamIds) {
            this.secondaryTeamIds = secondaryTeamIds;
            return this;
        }

        public Builder secondaryTeamIds(List<Integer> secondaryTeamIds) {
            this.secondaryTeamIds = Optional.ofNullable(secondaryTeamIds);
            return this;
        }

        public TeamPriorityLevel build() {
            return new TeamPriorityLevel(primaryTeamIds, secondaryTeamIds, additionalProperties);
        }
    }
}
