/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.visitors;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.contacts.types.Contact;
import com.intercom.api.resources.visitors.requests.FindVisitorRequest;
import com.intercom.api.resources.visitors.requests.MergeVisitorToContactRequest;
import com.intercom.api.types.UpdateVisitorRequest;
import com.intercom.api.types.Visitor;
import java.util.Optional;

public class VisitorsClient {
    protected final ClientOptions clientOptions;

    private final RawVisitorsClient rawClient;

    public VisitorsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawVisitorsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawVisitorsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * You can fetch the details of a single visitor.
     */
    public Optional<Visitor> find(FindVisitorRequest request) {
        return this.rawClient.find(request).body();
    }

    /**
     * You can fetch the details of a single visitor.
     */
    public Optional<Visitor> find(FindVisitorRequest request, RequestOptions requestOptions) {
        return this.rawClient.find(request, requestOptions).body();
    }

    /**
     * Sending a PUT request to <code>/visitors</code> will result in an update of an existing Visitor.
     * <p><strong>Option 1.</strong> You can update a visitor by passing in the <code>user_id</code> of the visitor in the Request body.</p>
     * <p><strong>Option 2.</strong> You can update a visitor by passing in the <code>id</code> of the visitor in the Request body.</p>
     */
    public Optional<Visitor> update(UpdateVisitorRequest request) {
        return this.rawClient.update(request).body();
    }

    /**
     * Sending a PUT request to <code>/visitors</code> will result in an update of an existing Visitor.
     * <p><strong>Option 1.</strong> You can update a visitor by passing in the <code>user_id</code> of the visitor in the Request body.</p>
     * <p><strong>Option 2.</strong> You can update a visitor by passing in the <code>id</code> of the visitor in the Request body.</p>
     */
    public Optional<Visitor> update(UpdateVisitorRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(request, requestOptions).body();
    }

    /**
     * You can merge a Visitor to a Contact of role type <code>lead</code> or <code>user</code>.
     * <blockquote>
     * <p>📘 What happens upon a visitor being converted?</p>
     * <p>If the User exists, then the Visitor will be merged into it, the Visitor deleted and the User returned. If the User does not exist, the Visitor will be converted to a User, with the User identifiers replacing it's Visitor identifiers.</p>
     * </blockquote>
     */
    public Contact mergeToContact(MergeVisitorToContactRequest request) {
        return this.rawClient.mergeToContact(request).body();
    }

    /**
     * You can merge a Visitor to a Contact of role type <code>lead</code> or <code>user</code>.
     * <blockquote>
     * <p>📘 What happens upon a visitor being converted?</p>
     * <p>If the User exists, then the Visitor will be merged into it, the Visitor deleted and the User returned. If the User does not exist, the Visitor will be converted to a User, with the User identifiers replacing it's Visitor identifiers.</p>
     * </blockquote>
     */
    public Contact mergeToContact(MergeVisitorToContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.mergeToContact(request, requestOptions).body();
    }
}
