/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = AdminWithApp.Builder.class)
public final class AdminWithApp {
    private final Optional<String> type;

    private final Optional<String> id;

    private final Optional<String> name;

    private final Optional<String> email;

    private final Optional<String> jobTitle;

    private final Optional<Boolean> awayModeEnabled;

    private final Optional<Boolean> awayModeReassign;

    private final Optional<Boolean> hasInboxSeat;

    private final Optional<List<Integer>> teamIds;

    private final Optional<Avatar> avatar;

    private final Optional<Boolean> emailVerified;

    private final Optional<App> app;

    private final Map<String, Object> additionalProperties;

    private AdminWithApp(
            Optional<String> type,
            Optional<String> id,
            Optional<String> name,
            Optional<String> email,
            Optional<String> jobTitle,
            Optional<Boolean> awayModeEnabled,
            Optional<Boolean> awayModeReassign,
            Optional<Boolean> hasInboxSeat,
            Optional<List<Integer>> teamIds,
            Optional<Avatar> avatar,
            Optional<Boolean> emailVerified,
            Optional<App> app,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.name = name;
        this.email = email;
        this.jobTitle = jobTitle;
        this.awayModeEnabled = awayModeEnabled;
        this.awayModeReassign = awayModeReassign;
        this.hasInboxSeat = hasInboxSeat;
        this.teamIds = teamIds;
        this.avatar = avatar;
        this.emailVerified = emailVerified;
        this.app = app;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return String representing the object's type. Always has the value <code>admin</code>.
     */
    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    /**
     * @return The id representing the admin.
     */
    @JsonProperty("id")
    public Optional<String> getId() {
        return id;
    }

    /**
     * @return The name of the admin.
     */
    @JsonProperty("name")
    public Optional<String> getName() {
        return name;
    }

    /**
     * @return The email of the admin.
     */
    @JsonProperty("email")
    public Optional<String> getEmail() {
        return email;
    }

    /**
     * @return The job title of the admin.
     */
    @JsonProperty("job_title")
    public Optional<String> getJobTitle() {
        return jobTitle;
    }

    /**
     * @return Identifies if this admin is currently set in away mode.
     */
    @JsonProperty("away_mode_enabled")
    public Optional<Boolean> getAwayModeEnabled() {
        return awayModeEnabled;
    }

    /**
     * @return Identifies if this admin is set to automatically reassign new conversations to the apps default inbox.
     */
    @JsonProperty("away_mode_reassign")
    public Optional<Boolean> getAwayModeReassign() {
        return awayModeReassign;
    }

    /**
     * @return Identifies if this admin has a paid inbox seat to restrict/allow features that require them.
     */
    @JsonProperty("has_inbox_seat")
    public Optional<Boolean> getHasInboxSeat() {
        return hasInboxSeat;
    }

    /**
     * @return This is a list of ids of the teams that this admin is part of.
     */
    @JsonProperty("team_ids")
    public Optional<List<Integer>> getTeamIds() {
        return teamIds;
    }

    /**
     * @return This object represents the avatar associated with the admin.
     */
    @JsonProperty("avatar")
    public Optional<Avatar> getAvatar() {
        return avatar;
    }

    /**
     * @return Identifies if this admin's email is verified.
     */
    @JsonProperty("email_verified")
    public Optional<Boolean> getEmailVerified() {
        return emailVerified;
    }

    /**
     * @return App that the admin belongs to.
     */
    @JsonProperty("app")
    public Optional<App> getApp() {
        return app;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof AdminWithApp && equalTo((AdminWithApp) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AdminWithApp other) {
        return type.equals(other.type)
                && id.equals(other.id)
                && name.equals(other.name)
                && email.equals(other.email)
                && jobTitle.equals(other.jobTitle)
                && awayModeEnabled.equals(other.awayModeEnabled)
                && awayModeReassign.equals(other.awayModeReassign)
                && hasInboxSeat.equals(other.hasInboxSeat)
                && teamIds.equals(other.teamIds)
                && avatar.equals(other.avatar)
                && emailVerified.equals(other.emailVerified)
                && app.equals(other.app);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.type,
                this.id,
                this.name,
                this.email,
                this.jobTitle,
                this.awayModeEnabled,
                this.awayModeReassign,
                this.hasInboxSeat,
                this.teamIds,
                this.avatar,
                this.emailVerified,
                this.app);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();

        private Optional<String> id = Optional.empty();

        private Optional<String> name = Optional.empty();

        private Optional<String> email = Optional.empty();

        private Optional<String> jobTitle = Optional.empty();

        private Optional<Boolean> awayModeEnabled = Optional.empty();

        private Optional<Boolean> awayModeReassign = Optional.empty();

        private Optional<Boolean> hasInboxSeat = Optional.empty();

        private Optional<List<Integer>> teamIds = Optional.empty();

        private Optional<Avatar> avatar = Optional.empty();

        private Optional<Boolean> emailVerified = Optional.empty();

        private Optional<App> app = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(AdminWithApp other) {
            type(other.getType());
            id(other.getId());
            name(other.getName());
            email(other.getEmail());
            jobTitle(other.getJobTitle());
            awayModeEnabled(other.getAwayModeEnabled());
            awayModeReassign(other.getAwayModeReassign());
            hasInboxSeat(other.getHasInboxSeat());
            teamIds(other.getTeamIds());
            avatar(other.getAvatar());
            emailVerified(other.getEmailVerified());
            app(other.getApp());
            return this;
        }

        /**
         * <p>String representing the object's type. Always has the value <code>admin</code>.</p>
         */
        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * <p>The id representing the admin.</p>
         */
        @JsonSetter(value = "id", nulls = Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        /**
         * <p>The name of the admin.</p>
         */
        @JsonSetter(value = "name", nulls = Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        /**
         * <p>The email of the admin.</p>
         */
        @JsonSetter(value = "email", nulls = Nulls.SKIP)
        public Builder email(Optional<String> email) {
            this.email = email;
            return this;
        }

        public Builder email(String email) {
            this.email = Optional.ofNullable(email);
            return this;
        }

        /**
         * <p>The job title of the admin.</p>
         */
        @JsonSetter(value = "job_title", nulls = Nulls.SKIP)
        public Builder jobTitle(Optional<String> jobTitle) {
            this.jobTitle = jobTitle;
            return this;
        }

        public Builder jobTitle(String jobTitle) {
            this.jobTitle = Optional.ofNullable(jobTitle);
            return this;
        }

        /**
         * <p>Identifies if this admin is currently set in away mode.</p>
         */
        @JsonSetter(value = "away_mode_enabled", nulls = Nulls.SKIP)
        public Builder awayModeEnabled(Optional<Boolean> awayModeEnabled) {
            this.awayModeEnabled = awayModeEnabled;
            return this;
        }

        public Builder awayModeEnabled(Boolean awayModeEnabled) {
            this.awayModeEnabled = Optional.ofNullable(awayModeEnabled);
            return this;
        }

        /**
         * <p>Identifies if this admin is set to automatically reassign new conversations to the apps default inbox.</p>
         */
        @JsonSetter(value = "away_mode_reassign", nulls = Nulls.SKIP)
        public Builder awayModeReassign(Optional<Boolean> awayModeReassign) {
            this.awayModeReassign = awayModeReassign;
            return this;
        }

        public Builder awayModeReassign(Boolean awayModeReassign) {
            this.awayModeReassign = Optional.ofNullable(awayModeReassign);
            return this;
        }

        /**
         * <p>Identifies if this admin has a paid inbox seat to restrict/allow features that require them.</p>
         */
        @JsonSetter(value = "has_inbox_seat", nulls = Nulls.SKIP)
        public Builder hasInboxSeat(Optional<Boolean> hasInboxSeat) {
            this.hasInboxSeat = hasInboxSeat;
            return this;
        }

        public Builder hasInboxSeat(Boolean hasInboxSeat) {
            this.hasInboxSeat = Optional.ofNullable(hasInboxSeat);
            return this;
        }

        /**
         * <p>This is a list of ids of the teams that this admin is part of.</p>
         */
        @JsonSetter(value = "team_ids", nulls = Nulls.SKIP)
        public Builder teamIds(Optional<List<Integer>> teamIds) {
            this.teamIds = teamIds;
            return this;
        }

        public Builder teamIds(List<Integer> teamIds) {
            this.teamIds = Optional.ofNullable(teamIds);
            return this;
        }

        /**
         * <p>This object represents the avatar associated with the admin.</p>
         */
        @JsonSetter(value = "avatar", nulls = Nulls.SKIP)
        public Builder avatar(Optional<Avatar> avatar) {
            this.avatar = avatar;
            return this;
        }

        public Builder avatar(Avatar avatar) {
            this.avatar = Optional.ofNullable(avatar);
            return this;
        }

        /**
         * <p>Identifies if this admin's email is verified.</p>
         */
        @JsonSetter(value = "email_verified", nulls = Nulls.SKIP)
        public Builder emailVerified(Optional<Boolean> emailVerified) {
            this.emailVerified = emailVerified;
            return this;
        }

        public Builder emailVerified(Boolean emailVerified) {
            this.emailVerified = Optional.ofNullable(emailVerified);
            return this;
        }

        /**
         * <p>App that the admin belongs to.</p>
         */
        @JsonSetter(value = "app", nulls = Nulls.SKIP)
        public Builder app(Optional<App> app) {
            this.app = app;
            return this;
        }

        public Builder app(App app) {
            this.app = Optional.ofNullable(app);
            return this;
        }

        public AdminWithApp build() {
            return new AdminWithApp(
                    type,
                    id,
                    name,
                    email,
                    jobTitle,
                    awayModeEnabled,
                    awayModeReassign,
                    hasInboxSeat,
                    teamIds,
                    avatar,
                    emailVerified,
                    app,
                    additionalProperties);
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = Avatar.Builder.class)
    public static final class Avatar {
        private final Optional<String> type;

        private final Optional<String> imageUrl;

        private final Map<String, Object> additionalProperties;

        private Avatar(Optional<String> type, Optional<String> imageUrl, Map<String, Object> additionalProperties) {
            this.type = type;
            this.imageUrl = imageUrl;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return This is a string that identifies the type of the object. It will always have the value <code>avatar</code>.
         */
        @JsonProperty("type")
        public Optional<String> getType() {
            return type;
        }

        /**
         * @return This object represents the avatar associated with the admin.
         */
        @JsonProperty("image_url")
        public Optional<String> getImageUrl() {
            return imageUrl;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof Avatar && equalTo((Avatar) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Avatar other) {
            return type.equals(other.type) && imageUrl.equals(other.imageUrl);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.type, this.imageUrl);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder {
            private Optional<String> type = Optional.empty();

            private Optional<String> imageUrl = Optional.empty();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            public Builder from(Avatar other) {
                type(other.getType());
                imageUrl(other.getImageUrl());
                return this;
            }

            /**
             * <p>This is a string that identifies the type of the object. It will always have the value <code>avatar</code>.</p>
             */
            @JsonSetter(value = "type", nulls = Nulls.SKIP)
            public Builder type(Optional<String> type) {
                this.type = type;
                return this;
            }

            public Builder type(String type) {
                this.type = Optional.ofNullable(type);
                return this;
            }

            /**
             * <p>This object represents the avatar associated with the admin.</p>
             */
            @JsonSetter(value = "image_url", nulls = Nulls.SKIP)
            public Builder imageUrl(Optional<String> imageUrl) {
                this.imageUrl = imageUrl;
                return this;
            }

            public Builder imageUrl(String imageUrl) {
                this.imageUrl = Optional.ofNullable(imageUrl);
                return this;
            }

            public Avatar build() {
                return new Avatar(type, imageUrl, additionalProperties);
            }
        }
    }
}
