/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ArticleStatistics.Builder.class)
public final class ArticleStatistics {
    private final int views;

    private final Optional<Integer> conversions;

    private final int reactions;

    private final float happyReactionPercentage;

    private final float neutralReactionPercentage;

    private final float sadReactionPercentage;

    private final Map<String, Object> additionalProperties;

    private ArticleStatistics(
            int views,
            Optional<Integer> conversions,
            int reactions,
            float happyReactionPercentage,
            float neutralReactionPercentage,
            float sadReactionPercentage,
            Map<String, Object> additionalProperties) {
        this.views = views;
        this.conversions = conversions;
        this.reactions = reactions;
        this.happyReactionPercentage = happyReactionPercentage;
        this.neutralReactionPercentage = neutralReactionPercentage;
        this.sadReactionPercentage = sadReactionPercentage;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of object - <code>article_statistics</code>.
     */
    @JsonProperty("type")
    public String getType() {
        return "article_statistics";
    }

    /**
     * @return The number of total views the article has received.
     */
    @JsonProperty("views")
    public int getViews() {
        return views;
    }

    /**
     * @return The number of conversations started from the article.
     */
    @JsonProperty("conversions")
    public Optional<Integer> getConversions() {
        return conversions;
    }

    /**
     * @return The number of total reactions the article has received.
     */
    @JsonProperty("reactions")
    public int getReactions() {
        return reactions;
    }

    /**
     * @return The percentage of happy reactions the article has received against other types of reaction.
     */
    @JsonProperty("happy_reaction_percentage")
    public float getHappyReactionPercentage() {
        return happyReactionPercentage;
    }

    /**
     * @return The percentage of neutral reactions the article has received against other types of reaction.
     */
    @JsonProperty("neutral_reaction_percentage")
    public float getNeutralReactionPercentage() {
        return neutralReactionPercentage;
    }

    /**
     * @return The percentage of sad reactions the article has received against other types of reaction.
     */
    @JsonProperty("sad_reaction_percentage")
    public float getSadReactionPercentage() {
        return sadReactionPercentage;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ArticleStatistics && equalTo((ArticleStatistics) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ArticleStatistics other) {
        return views == other.views
                && conversions.equals(other.conversions)
                && reactions == other.reactions
                && happyReactionPercentage == other.happyReactionPercentage
                && neutralReactionPercentage == other.neutralReactionPercentage
                && sadReactionPercentage == other.sadReactionPercentage;
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.views,
                this.conversions,
                this.reactions,
                this.happyReactionPercentage,
                this.neutralReactionPercentage,
                this.sadReactionPercentage);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ViewsStage builder() {
        return new Builder();
    }

    public interface ViewsStage {
        /**
         * <p>The number of total views the article has received.</p>
         */
        ReactionsStage views(int views);

        Builder from(ArticleStatistics other);
    }

    public interface ReactionsStage {
        /**
         * <p>The number of total reactions the article has received.</p>
         */
        HappyReactionPercentageStage reactions(int reactions);
    }

    public interface HappyReactionPercentageStage {
        /**
         * <p>The percentage of happy reactions the article has received against other types of reaction.</p>
         */
        NeutralReactionPercentageStage happyReactionPercentage(float happyReactionPercentage);
    }

    public interface NeutralReactionPercentageStage {
        /**
         * <p>The percentage of neutral reactions the article has received against other types of reaction.</p>
         */
        SadReactionPercentageStage neutralReactionPercentage(float neutralReactionPercentage);
    }

    public interface SadReactionPercentageStage {
        /**
         * <p>The percentage of sad reactions the article has received against other types of reaction.</p>
         */
        _FinalStage sadReactionPercentage(float sadReactionPercentage);
    }

    public interface _FinalStage {
        ArticleStatistics build();

        /**
         * <p>The number of conversations started from the article.</p>
         */
        _FinalStage conversions(Optional<Integer> conversions);

        _FinalStage conversions(Integer conversions);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements ViewsStage,
                    ReactionsStage,
                    HappyReactionPercentageStage,
                    NeutralReactionPercentageStage,
                    SadReactionPercentageStage,
                    _FinalStage {
        private int views;

        private int reactions;

        private float happyReactionPercentage;

        private float neutralReactionPercentage;

        private float sadReactionPercentage;

        private Optional<Integer> conversions = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ArticleStatistics other) {
            views(other.getViews());
            conversions(other.getConversions());
            reactions(other.getReactions());
            happyReactionPercentage(other.getHappyReactionPercentage());
            neutralReactionPercentage(other.getNeutralReactionPercentage());
            sadReactionPercentage(other.getSadReactionPercentage());
            return this;
        }

        /**
         * <p>The number of total views the article has received.</p>
         * <p>The number of total views the article has received.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("views")
        public ReactionsStage views(int views) {
            this.views = views;
            return this;
        }

        /**
         * <p>The number of total reactions the article has received.</p>
         * <p>The number of total reactions the article has received.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("reactions")
        public HappyReactionPercentageStage reactions(int reactions) {
            this.reactions = reactions;
            return this;
        }

        /**
         * <p>The percentage of happy reactions the article has received against other types of reaction.</p>
         * <p>The percentage of happy reactions the article has received against other types of reaction.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("happy_reaction_percentage")
        public NeutralReactionPercentageStage happyReactionPercentage(float happyReactionPercentage) {
            this.happyReactionPercentage = happyReactionPercentage;
            return this;
        }

        /**
         * <p>The percentage of neutral reactions the article has received against other types of reaction.</p>
         * <p>The percentage of neutral reactions the article has received against other types of reaction.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("neutral_reaction_percentage")
        public SadReactionPercentageStage neutralReactionPercentage(float neutralReactionPercentage) {
            this.neutralReactionPercentage = neutralReactionPercentage;
            return this;
        }

        /**
         * <p>The percentage of sad reactions the article has received against other types of reaction.</p>
         * <p>The percentage of sad reactions the article has received against other types of reaction.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("sad_reaction_percentage")
        public _FinalStage sadReactionPercentage(float sadReactionPercentage) {
            this.sadReactionPercentage = sadReactionPercentage;
            return this;
        }

        /**
         * <p>The number of conversations started from the article.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage conversions(Integer conversions) {
            this.conversions = Optional.ofNullable(conversions);
            return this;
        }

        /**
         * <p>The number of conversations started from the article.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "conversions", nulls = Nulls.SKIP)
        public _FinalStage conversions(Optional<Integer> conversions) {
            this.conversions = conversions;
            return this;
        }

        @java.lang.Override
        public ArticleStatistics build() {
            return new ArticleStatistics(
                    views,
                    conversions,
                    reactions,
                    happyReactionPercentage,
                    neutralReactionPercentage,
                    sadReactionPercentage,
                    additionalProperties);
        }
    }
}
