/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CreateInternalArticleRequest.Builder.class)
public final class CreateInternalArticleRequest {
    private final String title;

    private final Optional<String> body;

    private final int authorId;

    private final int ownerId;

    private final Map<String, Object> additionalProperties;

    private CreateInternalArticleRequest(
            String title, Optional<String> body, int authorId, int ownerId, Map<String, Object> additionalProperties) {
        this.title = title;
        this.body = body;
        this.authorId = authorId;
        this.ownerId = ownerId;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The title of the article.
     */
    @JsonProperty("title")
    public String getTitle() {
        return title;
    }

    /**
     * @return The content of the article.
     */
    @JsonProperty("body")
    public Optional<String> getBody() {
        return body;
    }

    /**
     * @return The id of the author of the article.
     */
    @JsonProperty("author_id")
    public int getAuthorId() {
        return authorId;
    }

    /**
     * @return The id of the owner of the article.
     */
    @JsonProperty("owner_id")
    public int getOwnerId() {
        return ownerId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CreateInternalArticleRequest && equalTo((CreateInternalArticleRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateInternalArticleRequest other) {
        return title.equals(other.title)
                && body.equals(other.body)
                && authorId == other.authorId
                && ownerId == other.ownerId;
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.title, this.body, this.authorId, this.ownerId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TitleStage builder() {
        return new Builder();
    }

    public interface TitleStage {
        /**
         * <p>The title of the article.</p>
         */
        AuthorIdStage title(@NotNull String title);

        Builder from(CreateInternalArticleRequest other);
    }

    public interface AuthorIdStage {
        /**
         * <p>The id of the author of the article.</p>
         */
        OwnerIdStage authorId(int authorId);
    }

    public interface OwnerIdStage {
        /**
         * <p>The id of the owner of the article.</p>
         */
        _FinalStage ownerId(int ownerId);
    }

    public interface _FinalStage {
        CreateInternalArticleRequest build();

        /**
         * <p>The content of the article.</p>
         */
        _FinalStage body(Optional<String> body);

        _FinalStage body(String body);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TitleStage, AuthorIdStage, OwnerIdStage, _FinalStage {
        private String title;

        private int authorId;

        private int ownerId;

        private Optional<String> body = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CreateInternalArticleRequest other) {
            title(other.getTitle());
            body(other.getBody());
            authorId(other.getAuthorId());
            ownerId(other.getOwnerId());
            return this;
        }

        /**
         * <p>The title of the article.</p>
         * <p>The title of the article.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("title")
        public AuthorIdStage title(@NotNull String title) {
            this.title = Objects.requireNonNull(title, "title must not be null");
            return this;
        }

        /**
         * <p>The id of the author of the article.</p>
         * <p>The id of the author of the article.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("author_id")
        public OwnerIdStage authorId(int authorId) {
            this.authorId = authorId;
            return this;
        }

        /**
         * <p>The id of the owner of the article.</p>
         * <p>The id of the owner of the article.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("owner_id")
        public _FinalStage ownerId(int ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        /**
         * <p>The content of the article.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage body(String body) {
            this.body = Optional.ofNullable(body);
            return this;
        }

        /**
         * <p>The content of the article.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "body", nulls = Nulls.SKIP)
        public _FinalStage body(Optional<String> body) {
            this.body = body;
            return this;
        }

        @java.lang.Override
        public CreateInternalArticleRequest build() {
            return new CreateInternalArticleRequest(title, body, authorId, ownerId, additionalProperties);
        }
    }
}
