/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = DataExportCsv.Builder.class)
public final class DataExportCsv {
    private final Optional<String> userId;

    private final Optional<String> userExternalId;

    private final Optional<String> companyId;

    private final Optional<String> email;

    private final Optional<String> name;

    private final Optional<String> rulesetId;

    private final Optional<String> contentId;

    private final Optional<String> contentType;

    private final Optional<String> contentTitle;

    private final Optional<String> rulesetVersionId;

    private final Optional<String> receiptId;

    private final Optional<Integer> receivedAt;

    private final Optional<String> seriesId;

    private final Optional<String> seriesTitle;

    private final Optional<String> nodeId;

    private final Optional<Integer> firstReply;

    private final Optional<Integer> firstCompletion;

    private final Optional<Integer> firstSeriesCompletion;

    private final Optional<Integer> firstSeriesDisengagement;

    private final Optional<Integer> firstSeriesExit;

    private final Optional<Integer> firstGoalSuccess;

    private final Optional<Integer> firstOpen;

    private final Optional<Integer> firstClick;

    private final Optional<Integer> firstDismisall;

    private final Optional<Integer> firstUnsubscribe;

    private final Optional<Integer> firstHardBounce;

    private final Map<String, Object> additionalProperties;

    private DataExportCsv(
            Optional<String> userId,
            Optional<String> userExternalId,
            Optional<String> companyId,
            Optional<String> email,
            Optional<String> name,
            Optional<String> rulesetId,
            Optional<String> contentId,
            Optional<String> contentType,
            Optional<String> contentTitle,
            Optional<String> rulesetVersionId,
            Optional<String> receiptId,
            Optional<Integer> receivedAt,
            Optional<String> seriesId,
            Optional<String> seriesTitle,
            Optional<String> nodeId,
            Optional<Integer> firstReply,
            Optional<Integer> firstCompletion,
            Optional<Integer> firstSeriesCompletion,
            Optional<Integer> firstSeriesDisengagement,
            Optional<Integer> firstSeriesExit,
            Optional<Integer> firstGoalSuccess,
            Optional<Integer> firstOpen,
            Optional<Integer> firstClick,
            Optional<Integer> firstDismisall,
            Optional<Integer> firstUnsubscribe,
            Optional<Integer> firstHardBounce,
            Map<String, Object> additionalProperties) {
        this.userId = userId;
        this.userExternalId = userExternalId;
        this.companyId = companyId;
        this.email = email;
        this.name = name;
        this.rulesetId = rulesetId;
        this.contentId = contentId;
        this.contentType = contentType;
        this.contentTitle = contentTitle;
        this.rulesetVersionId = rulesetVersionId;
        this.receiptId = receiptId;
        this.receivedAt = receivedAt;
        this.seriesId = seriesId;
        this.seriesTitle = seriesTitle;
        this.nodeId = nodeId;
        this.firstReply = firstReply;
        this.firstCompletion = firstCompletion;
        this.firstSeriesCompletion = firstSeriesCompletion;
        this.firstSeriesDisengagement = firstSeriesDisengagement;
        this.firstSeriesExit = firstSeriesExit;
        this.firstGoalSuccess = firstGoalSuccess;
        this.firstOpen = firstOpen;
        this.firstClick = firstClick;
        this.firstDismisall = firstDismisall;
        this.firstUnsubscribe = firstUnsubscribe;
        this.firstHardBounce = firstHardBounce;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The user_id of the user who was sent the message.
     */
    @JsonProperty("user_id")
    public Optional<String> getUserId() {
        return userId;
    }

    /**
     * @return The external_user_id of the user who was sent the message
     */
    @JsonProperty("user_external_id")
    public Optional<String> getUserExternalId() {
        return userExternalId;
    }

    /**
     * @return The company ID of the user in relation to the message that was sent. Will return -1 if no company is present.
     */
    @JsonProperty("company_id")
    public Optional<String> getCompanyId() {
        return companyId;
    }

    /**
     * @return The users email who was sent the message.
     */
    @JsonProperty("email")
    public Optional<String> getEmail() {
        return email;
    }

    /**
     * @return The full name of the user receiving the message
     */
    @JsonProperty("name")
    public Optional<String> getName() {
        return name;
    }

    /**
     * @return The id of the message.
     */
    @JsonProperty("ruleset_id")
    public Optional<String> getRulesetId() {
        return rulesetId;
    }

    /**
     * @return The specific content that was received. In an A/B test each version has its own Content ID.
     */
    @JsonProperty("content_id")
    public Optional<String> getContentId() {
        return contentId;
    }

    /**
     * @return Email, Chat, Post etc.
     */
    @JsonProperty("content_type")
    public Optional<String> getContentType() {
        return contentType;
    }

    /**
     * @return The title of the content you see in your Intercom workspace.
     */
    @JsonProperty("content_title")
    public Optional<String> getContentTitle() {
        return contentTitle;
    }

    /**
     * @return As you edit content we record new versions. This ID can help you determine which version of a piece of content that was received.
     */
    @JsonProperty("ruleset_version_id")
    public Optional<String> getRulesetVersionId() {
        return rulesetVersionId;
    }

    /**
     * @return ID for this receipt. Will be included with any related stats in other files to identify this specific delivery of a message.
     */
    @JsonProperty("receipt_id")
    public Optional<String> getReceiptId() {
        return receiptId;
    }

    /**
     * @return Timestamp for when the receipt was recorded.
     */
    @JsonProperty("received_at")
    public Optional<Integer> getReceivedAt() {
        return receivedAt;
    }

    /**
     * @return The id of the series that this content is part of. Will return -1 if not part of a series.
     */
    @JsonProperty("series_id")
    public Optional<String> getSeriesId() {
        return seriesId;
    }

    /**
     * @return The title of the series that this content is part of.
     */
    @JsonProperty("series_title")
    public Optional<String> getSeriesTitle() {
        return seriesTitle;
    }

    /**
     * @return The id of the series node that this ruleset is associated with. Each block in a series has a corresponding node_id.
     */
    @JsonProperty("node_id")
    public Optional<String> getNodeId() {
        return nodeId;
    }

    /**
     * @return The first time a user replied to this message if the content was able to receive replies.
     */
    @JsonProperty("first_reply")
    public Optional<Integer> getFirstReply() {
        return firstReply;
    }

    /**
     * @return The first time a user completed this message if the content was able to be completed e.g. Tours, Surveys.
     */
    @JsonProperty("first_completion")
    public Optional<Integer> getFirstCompletion() {
        return firstCompletion;
    }

    /**
     * @return The first time the series this message was a part of was completed by the user.
     */
    @JsonProperty("first_series_completion")
    public Optional<Integer> getFirstSeriesCompletion() {
        return firstSeriesCompletion;
    }

    /**
     * @return The first time the series this message was a part of was disengaged by the user.
     */
    @JsonProperty("first_series_disengagement")
    public Optional<Integer> getFirstSeriesDisengagement() {
        return firstSeriesDisengagement;
    }

    /**
     * @return The first time the series this message was a part of was exited by the user.
     */
    @JsonProperty("first_series_exit")
    public Optional<Integer> getFirstSeriesExit() {
        return firstSeriesExit;
    }

    /**
     * @return The first time the user met this messages associated goal if one exists.
     */
    @JsonProperty("first_goal_success")
    public Optional<Integer> getFirstGoalSuccess() {
        return firstGoalSuccess;
    }

    /**
     * @return The first time the user opened this message.
     */
    @JsonProperty("first_open")
    public Optional<Integer> getFirstOpen() {
        return firstOpen;
    }

    /**
     * @return The first time the series the user clicked on a link within this message.
     */
    @JsonProperty("first_click")
    public Optional<Integer> getFirstClick() {
        return firstClick;
    }

    /**
     * @return The first time the series the user dismissed this message.
     */
    @JsonProperty("first_dismisall")
    public Optional<Integer> getFirstDismisall() {
        return firstDismisall;
    }

    /**
     * @return The first time the user unsubscribed from this message.
     */
    @JsonProperty("first_unsubscribe")
    public Optional<Integer> getFirstUnsubscribe() {
        return firstUnsubscribe;
    }

    /**
     * @return The first time this message hard bounced for this user
     */
    @JsonProperty("first_hard_bounce")
    public Optional<Integer> getFirstHardBounce() {
        return firstHardBounce;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof DataExportCsv && equalTo((DataExportCsv) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DataExportCsv other) {
        return userId.equals(other.userId)
                && userExternalId.equals(other.userExternalId)
                && companyId.equals(other.companyId)
                && email.equals(other.email)
                && name.equals(other.name)
                && rulesetId.equals(other.rulesetId)
                && contentId.equals(other.contentId)
                && contentType.equals(other.contentType)
                && contentTitle.equals(other.contentTitle)
                && rulesetVersionId.equals(other.rulesetVersionId)
                && receiptId.equals(other.receiptId)
                && receivedAt.equals(other.receivedAt)
                && seriesId.equals(other.seriesId)
                && seriesTitle.equals(other.seriesTitle)
                && nodeId.equals(other.nodeId)
                && firstReply.equals(other.firstReply)
                && firstCompletion.equals(other.firstCompletion)
                && firstSeriesCompletion.equals(other.firstSeriesCompletion)
                && firstSeriesDisengagement.equals(other.firstSeriesDisengagement)
                && firstSeriesExit.equals(other.firstSeriesExit)
                && firstGoalSuccess.equals(other.firstGoalSuccess)
                && firstOpen.equals(other.firstOpen)
                && firstClick.equals(other.firstClick)
                && firstDismisall.equals(other.firstDismisall)
                && firstUnsubscribe.equals(other.firstUnsubscribe)
                && firstHardBounce.equals(other.firstHardBounce);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.userId,
                this.userExternalId,
                this.companyId,
                this.email,
                this.name,
                this.rulesetId,
                this.contentId,
                this.contentType,
                this.contentTitle,
                this.rulesetVersionId,
                this.receiptId,
                this.receivedAt,
                this.seriesId,
                this.seriesTitle,
                this.nodeId,
                this.firstReply,
                this.firstCompletion,
                this.firstSeriesCompletion,
                this.firstSeriesDisengagement,
                this.firstSeriesExit,
                this.firstGoalSuccess,
                this.firstOpen,
                this.firstClick,
                this.firstDismisall,
                this.firstUnsubscribe,
                this.firstHardBounce);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> userId = Optional.empty();

        private Optional<String> userExternalId = Optional.empty();

        private Optional<String> companyId = Optional.empty();

        private Optional<String> email = Optional.empty();

        private Optional<String> name = Optional.empty();

        private Optional<String> rulesetId = Optional.empty();

        private Optional<String> contentId = Optional.empty();

        private Optional<String> contentType = Optional.empty();

        private Optional<String> contentTitle = Optional.empty();

        private Optional<String> rulesetVersionId = Optional.empty();

        private Optional<String> receiptId = Optional.empty();

        private Optional<Integer> receivedAt = Optional.empty();

        private Optional<String> seriesId = Optional.empty();

        private Optional<String> seriesTitle = Optional.empty();

        private Optional<String> nodeId = Optional.empty();

        private Optional<Integer> firstReply = Optional.empty();

        private Optional<Integer> firstCompletion = Optional.empty();

        private Optional<Integer> firstSeriesCompletion = Optional.empty();

        private Optional<Integer> firstSeriesDisengagement = Optional.empty();

        private Optional<Integer> firstSeriesExit = Optional.empty();

        private Optional<Integer> firstGoalSuccess = Optional.empty();

        private Optional<Integer> firstOpen = Optional.empty();

        private Optional<Integer> firstClick = Optional.empty();

        private Optional<Integer> firstDismisall = Optional.empty();

        private Optional<Integer> firstUnsubscribe = Optional.empty();

        private Optional<Integer> firstHardBounce = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(DataExportCsv other) {
            userId(other.getUserId());
            userExternalId(other.getUserExternalId());
            companyId(other.getCompanyId());
            email(other.getEmail());
            name(other.getName());
            rulesetId(other.getRulesetId());
            contentId(other.getContentId());
            contentType(other.getContentType());
            contentTitle(other.getContentTitle());
            rulesetVersionId(other.getRulesetVersionId());
            receiptId(other.getReceiptId());
            receivedAt(other.getReceivedAt());
            seriesId(other.getSeriesId());
            seriesTitle(other.getSeriesTitle());
            nodeId(other.getNodeId());
            firstReply(other.getFirstReply());
            firstCompletion(other.getFirstCompletion());
            firstSeriesCompletion(other.getFirstSeriesCompletion());
            firstSeriesDisengagement(other.getFirstSeriesDisengagement());
            firstSeriesExit(other.getFirstSeriesExit());
            firstGoalSuccess(other.getFirstGoalSuccess());
            firstOpen(other.getFirstOpen());
            firstClick(other.getFirstClick());
            firstDismisall(other.getFirstDismisall());
            firstUnsubscribe(other.getFirstUnsubscribe());
            firstHardBounce(other.getFirstHardBounce());
            return this;
        }

        /**
         * <p>The user_id of the user who was sent the message.</p>
         */
        @JsonSetter(value = "user_id", nulls = Nulls.SKIP)
        public Builder userId(Optional<String> userId) {
            this.userId = userId;
            return this;
        }

        public Builder userId(String userId) {
            this.userId = Optional.ofNullable(userId);
            return this;
        }

        /**
         * <p>The external_user_id of the user who was sent the message</p>
         */
        @JsonSetter(value = "user_external_id", nulls = Nulls.SKIP)
        public Builder userExternalId(Optional<String> userExternalId) {
            this.userExternalId = userExternalId;
            return this;
        }

        public Builder userExternalId(String userExternalId) {
            this.userExternalId = Optional.ofNullable(userExternalId);
            return this;
        }

        /**
         * <p>The company ID of the user in relation to the message that was sent. Will return -1 if no company is present.</p>
         */
        @JsonSetter(value = "company_id", nulls = Nulls.SKIP)
        public Builder companyId(Optional<String> companyId) {
            this.companyId = companyId;
            return this;
        }

        public Builder companyId(String companyId) {
            this.companyId = Optional.ofNullable(companyId);
            return this;
        }

        /**
         * <p>The users email who was sent the message.</p>
         */
        @JsonSetter(value = "email", nulls = Nulls.SKIP)
        public Builder email(Optional<String> email) {
            this.email = email;
            return this;
        }

        public Builder email(String email) {
            this.email = Optional.ofNullable(email);
            return this;
        }

        /**
         * <p>The full name of the user receiving the message</p>
         */
        @JsonSetter(value = "name", nulls = Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        /**
         * <p>The id of the message.</p>
         */
        @JsonSetter(value = "ruleset_id", nulls = Nulls.SKIP)
        public Builder rulesetId(Optional<String> rulesetId) {
            this.rulesetId = rulesetId;
            return this;
        }

        public Builder rulesetId(String rulesetId) {
            this.rulesetId = Optional.ofNullable(rulesetId);
            return this;
        }

        /**
         * <p>The specific content that was received. In an A/B test each version has its own Content ID.</p>
         */
        @JsonSetter(value = "content_id", nulls = Nulls.SKIP)
        public Builder contentId(Optional<String> contentId) {
            this.contentId = contentId;
            return this;
        }

        public Builder contentId(String contentId) {
            this.contentId = Optional.ofNullable(contentId);
            return this;
        }

        /**
         * <p>Email, Chat, Post etc.</p>
         */
        @JsonSetter(value = "content_type", nulls = Nulls.SKIP)
        public Builder contentType(Optional<String> contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = Optional.ofNullable(contentType);
            return this;
        }

        /**
         * <p>The title of the content you see in your Intercom workspace.</p>
         */
        @JsonSetter(value = "content_title", nulls = Nulls.SKIP)
        public Builder contentTitle(Optional<String> contentTitle) {
            this.contentTitle = contentTitle;
            return this;
        }

        public Builder contentTitle(String contentTitle) {
            this.contentTitle = Optional.ofNullable(contentTitle);
            return this;
        }

        /**
         * <p>As you edit content we record new versions. This ID can help you determine which version of a piece of content that was received.</p>
         */
        @JsonSetter(value = "ruleset_version_id", nulls = Nulls.SKIP)
        public Builder rulesetVersionId(Optional<String> rulesetVersionId) {
            this.rulesetVersionId = rulesetVersionId;
            return this;
        }

        public Builder rulesetVersionId(String rulesetVersionId) {
            this.rulesetVersionId = Optional.ofNullable(rulesetVersionId);
            return this;
        }

        /**
         * <p>ID for this receipt. Will be included with any related stats in other files to identify this specific delivery of a message.</p>
         */
        @JsonSetter(value = "receipt_id", nulls = Nulls.SKIP)
        public Builder receiptId(Optional<String> receiptId) {
            this.receiptId = receiptId;
            return this;
        }

        public Builder receiptId(String receiptId) {
            this.receiptId = Optional.ofNullable(receiptId);
            return this;
        }

        /**
         * <p>Timestamp for when the receipt was recorded.</p>
         */
        @JsonSetter(value = "received_at", nulls = Nulls.SKIP)
        public Builder receivedAt(Optional<Integer> receivedAt) {
            this.receivedAt = receivedAt;
            return this;
        }

        public Builder receivedAt(Integer receivedAt) {
            this.receivedAt = Optional.ofNullable(receivedAt);
            return this;
        }

        /**
         * <p>The id of the series that this content is part of. Will return -1 if not part of a series.</p>
         */
        @JsonSetter(value = "series_id", nulls = Nulls.SKIP)
        public Builder seriesId(Optional<String> seriesId) {
            this.seriesId = seriesId;
            return this;
        }

        public Builder seriesId(String seriesId) {
            this.seriesId = Optional.ofNullable(seriesId);
            return this;
        }

        /**
         * <p>The title of the series that this content is part of.</p>
         */
        @JsonSetter(value = "series_title", nulls = Nulls.SKIP)
        public Builder seriesTitle(Optional<String> seriesTitle) {
            this.seriesTitle = seriesTitle;
            return this;
        }

        public Builder seriesTitle(String seriesTitle) {
            this.seriesTitle = Optional.ofNullable(seriesTitle);
            return this;
        }

        /**
         * <p>The id of the series node that this ruleset is associated with. Each block in a series has a corresponding node_id.</p>
         */
        @JsonSetter(value = "node_id", nulls = Nulls.SKIP)
        public Builder nodeId(Optional<String> nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public Builder nodeId(String nodeId) {
            this.nodeId = Optional.ofNullable(nodeId);
            return this;
        }

        /**
         * <p>The first time a user replied to this message if the content was able to receive replies.</p>
         */
        @JsonSetter(value = "first_reply", nulls = Nulls.SKIP)
        public Builder firstReply(Optional<Integer> firstReply) {
            this.firstReply = firstReply;
            return this;
        }

        public Builder firstReply(Integer firstReply) {
            this.firstReply = Optional.ofNullable(firstReply);
            return this;
        }

        /**
         * <p>The first time a user completed this message if the content was able to be completed e.g. Tours, Surveys.</p>
         */
        @JsonSetter(value = "first_completion", nulls = Nulls.SKIP)
        public Builder firstCompletion(Optional<Integer> firstCompletion) {
            this.firstCompletion = firstCompletion;
            return this;
        }

        public Builder firstCompletion(Integer firstCompletion) {
            this.firstCompletion = Optional.ofNullable(firstCompletion);
            return this;
        }

        /**
         * <p>The first time the series this message was a part of was completed by the user.</p>
         */
        @JsonSetter(value = "first_series_completion", nulls = Nulls.SKIP)
        public Builder firstSeriesCompletion(Optional<Integer> firstSeriesCompletion) {
            this.firstSeriesCompletion = firstSeriesCompletion;
            return this;
        }

        public Builder firstSeriesCompletion(Integer firstSeriesCompletion) {
            this.firstSeriesCompletion = Optional.ofNullable(firstSeriesCompletion);
            return this;
        }

        /**
         * <p>The first time the series this message was a part of was disengaged by the user.</p>
         */
        @JsonSetter(value = "first_series_disengagement", nulls = Nulls.SKIP)
        public Builder firstSeriesDisengagement(Optional<Integer> firstSeriesDisengagement) {
            this.firstSeriesDisengagement = firstSeriesDisengagement;
            return this;
        }

        public Builder firstSeriesDisengagement(Integer firstSeriesDisengagement) {
            this.firstSeriesDisengagement = Optional.ofNullable(firstSeriesDisengagement);
            return this;
        }

        /**
         * <p>The first time the series this message was a part of was exited by the user.</p>
         */
        @JsonSetter(value = "first_series_exit", nulls = Nulls.SKIP)
        public Builder firstSeriesExit(Optional<Integer> firstSeriesExit) {
            this.firstSeriesExit = firstSeriesExit;
            return this;
        }

        public Builder firstSeriesExit(Integer firstSeriesExit) {
            this.firstSeriesExit = Optional.ofNullable(firstSeriesExit);
            return this;
        }

        /**
         * <p>The first time the user met this messages associated goal if one exists.</p>
         */
        @JsonSetter(value = "first_goal_success", nulls = Nulls.SKIP)
        public Builder firstGoalSuccess(Optional<Integer> firstGoalSuccess) {
            this.firstGoalSuccess = firstGoalSuccess;
            return this;
        }

        public Builder firstGoalSuccess(Integer firstGoalSuccess) {
            this.firstGoalSuccess = Optional.ofNullable(firstGoalSuccess);
            return this;
        }

        /**
         * <p>The first time the user opened this message.</p>
         */
        @JsonSetter(value = "first_open", nulls = Nulls.SKIP)
        public Builder firstOpen(Optional<Integer> firstOpen) {
            this.firstOpen = firstOpen;
            return this;
        }

        public Builder firstOpen(Integer firstOpen) {
            this.firstOpen = Optional.ofNullable(firstOpen);
            return this;
        }

        /**
         * <p>The first time the series the user clicked on a link within this message.</p>
         */
        @JsonSetter(value = "first_click", nulls = Nulls.SKIP)
        public Builder firstClick(Optional<Integer> firstClick) {
            this.firstClick = firstClick;
            return this;
        }

        public Builder firstClick(Integer firstClick) {
            this.firstClick = Optional.ofNullable(firstClick);
            return this;
        }

        /**
         * <p>The first time the series the user dismissed this message.</p>
         */
        @JsonSetter(value = "first_dismisall", nulls = Nulls.SKIP)
        public Builder firstDismisall(Optional<Integer> firstDismisall) {
            this.firstDismisall = firstDismisall;
            return this;
        }

        public Builder firstDismisall(Integer firstDismisall) {
            this.firstDismisall = Optional.ofNullable(firstDismisall);
            return this;
        }

        /**
         * <p>The first time the user unsubscribed from this message.</p>
         */
        @JsonSetter(value = "first_unsubscribe", nulls = Nulls.SKIP)
        public Builder firstUnsubscribe(Optional<Integer> firstUnsubscribe) {
            this.firstUnsubscribe = firstUnsubscribe;
            return this;
        }

        public Builder firstUnsubscribe(Integer firstUnsubscribe) {
            this.firstUnsubscribe = Optional.ofNullable(firstUnsubscribe);
            return this;
        }

        /**
         * <p>The first time this message hard bounced for this user</p>
         */
        @JsonSetter(value = "first_hard_bounce", nulls = Nulls.SKIP)
        public Builder firstHardBounce(Optional<Integer> firstHardBounce) {
            this.firstHardBounce = firstHardBounce;
            return this;
        }

        public Builder firstHardBounce(Integer firstHardBounce) {
            this.firstHardBounce = Optional.ofNullable(firstHardBounce);
            return this;
        }

        public DataExportCsv build() {
            return new DataExportCsv(
                    userId,
                    userExternalId,
                    companyId,
                    email,
                    name,
                    rulesetId,
                    contentId,
                    contentType,
                    contentTitle,
                    rulesetVersionId,
                    receiptId,
                    receivedAt,
                    seriesId,
                    seriesTitle,
                    nodeId,
                    firstReply,
                    firstCompletion,
                    firstSeriesCompletion,
                    firstSeriesDisengagement,
                    firstSeriesExit,
                    firstGoalSuccess,
                    firstOpen,
                    firstClick,
                    firstDismisall,
                    firstUnsubscribe,
                    firstHardBounce,
                    additionalProperties);
        }
    }
}
