/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = TagMultipleUsersRequest.Builder.class)
public final class TagMultipleUsersRequest {
    private final String name;

    private final List<UsersItem> users;

    private final Map<String, Object> additionalProperties;

    private TagMultipleUsersRequest(String name, List<UsersItem> users, Map<String, Object> additionalProperties) {
        this.name = name;
        this.users = users;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The name of the tag, which will be created if not found.
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    @JsonProperty("users")
    public List<UsersItem> getUsers() {
        return users;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof TagMultipleUsersRequest && equalTo((TagMultipleUsersRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TagMultipleUsersRequest other) {
        return name.equals(other.name) && users.equals(other.users);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.name, this.users);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    public interface NameStage {
        /**
         * <p>The name of the tag, which will be created if not found.</p>
         */
        _FinalStage name(@NotNull String name);

        Builder from(TagMultipleUsersRequest other);
    }

    public interface _FinalStage {
        TagMultipleUsersRequest build();

        _FinalStage users(List<UsersItem> users);

        _FinalStage addUsers(UsersItem users);

        _FinalStage addAllUsers(List<UsersItem> users);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements NameStage, _FinalStage {
        private String name;

        private List<UsersItem> users = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(TagMultipleUsersRequest other) {
            name(other.getName());
            users(other.getUsers());
            return this;
        }

        /**
         * <p>The name of the tag, which will be created if not found.</p>
         * <p>The name of the tag, which will be created if not found.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("name")
        public _FinalStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllUsers(List<UsersItem> users) {
            if (users != null) {
                this.users.addAll(users);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addUsers(UsersItem users) {
            this.users.add(users);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "users", nulls = Nulls.SKIP)
        public _FinalStage users(List<UsersItem> users) {
            this.users.clear();
            if (users != null) {
                this.users.addAll(users);
            }
            return this;
        }

        @java.lang.Override
        public TagMultipleUsersRequest build() {
            return new TagMultipleUsersRequest(name, users, additionalProperties);
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = UsersItem.Builder.class)
    public static final class UsersItem {
        private final Optional<String> id;

        private final Map<String, Object> additionalProperties;

        private UsersItem(Optional<String> id, Map<String, Object> additionalProperties) {
            this.id = id;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return The Intercom defined id representing the user.
         */
        @JsonProperty("id")
        public Optional<String> getId() {
            return id;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof UsersItem && equalTo((UsersItem) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(UsersItem other) {
            return id.equals(other.id);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.id);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder {
            private Optional<String> id = Optional.empty();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            public Builder from(UsersItem other) {
                id(other.getId());
                return this;
            }

            /**
             * <p>The Intercom defined id representing the user.</p>
             */
            @JsonSetter(value = "id", nulls = Nulls.SKIP)
            public Builder id(Optional<String> id) {
                this.id = id;
                return this;
            }

            public Builder id(String id) {
                this.id = Optional.ofNullable(id);
                return this;
            }

            public UsersItem build() {
                return new UsersItem(id, additionalProperties);
            }
        }
    }
}
