/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.intercom.api.core.ObjectMappers;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonDeserialize(using = UpdateVisitorRequest.Deserializer.class)
public final class UpdateVisitorRequest {
    private final Object value;

    private final int type;

    private UpdateVisitorRequest(Object value, int type) {
        this.value = value;
        this.type = type;
    }

    @JsonValue
    public Object get() {
        return this.value;
    }

    @SuppressWarnings("unchecked")
    public <T> T visit(Visitor<T> visitor) {
        if (this.type == 0) {
            return visitor.visit((WithId) this.value);
        } else if (this.type == 1) {
            return visitor.visit((WithUserId) this.value);
        }
        throw new IllegalStateException("Failed to visit value. This should never happen.");
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof UpdateVisitorRequest && equalTo((UpdateVisitorRequest) other);
    }

    private boolean equalTo(UpdateVisitorRequest other) {
        return value.equals(other.value);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.value);
    }

    @java.lang.Override
    public String toString() {
        return this.value.toString();
    }

    public static UpdateVisitorRequest of(WithId value) {
        return new UpdateVisitorRequest(value, 0);
    }

    public static UpdateVisitorRequest of(WithUserId value) {
        return new UpdateVisitorRequest(value, 1);
    }

    public interface Visitor<T> {
        T visit(WithId value);

        T visit(WithUserId value);
    }

    static final class Deserializer extends StdDeserializer<UpdateVisitorRequest> {
        Deserializer() {
            super(UpdateVisitorRequest.class);
        }

        @java.lang.Override
        public UpdateVisitorRequest deserialize(JsonParser p, DeserializationContext context) throws IOException {
            Object value = p.readValueAs(Object.class);
            try {
                return of(ObjectMappers.JSON_MAPPER.convertValue(value, WithId.class));
            } catch (RuntimeException e) {
            }
            try {
                return of(ObjectMappers.JSON_MAPPER.convertValue(value, WithUserId.class));
            } catch (RuntimeException e) {
            }
            throw new JsonParseException(p, "Failed to deserialize");
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = WithUserId.Builder.class)
    public static final class WithUserId {
        private final String userId;

        private final Optional<String> name;

        private final Optional<Map<String, String>> customAttributes;

        private final Map<String, Object> additionalProperties;

        private WithUserId(
                String userId,
                Optional<String> name,
                Optional<Map<String, String>> customAttributes,
                Map<String, Object> additionalProperties) {
            this.userId = userId;
            this.name = name;
            this.customAttributes = customAttributes;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return A unique identified for the visitor which is given by you.
         */
        @JsonProperty("user_id")
        public String getUserId() {
            return userId;
        }

        /**
         * @return The visitor's name.
         */
        @JsonProperty("name")
        public Optional<String> getName() {
            return name;
        }

        /**
         * @return The custom attributes which are set for the visitor.
         */
        @JsonProperty("custom_attributes")
        public Optional<Map<String, String>> getCustomAttributes() {
            return customAttributes;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof WithUserId && equalTo((WithUserId) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(WithUserId other) {
            return userId.equals(other.userId)
                    && name.equals(other.name)
                    && customAttributes.equals(other.customAttributes);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.userId, this.name, this.customAttributes);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static UserIdStage builder() {
            return new Builder();
        }

        public interface UserIdStage {
            /**
             * <p>A unique identified for the visitor which is given by you.</p>
             */
            _FinalStage userId(@NotNull String userId);

            Builder from(WithUserId other);
        }

        public interface _FinalStage {
            WithUserId build();

            /**
             * <p>The visitor's name.</p>
             */
            _FinalStage name(Optional<String> name);

            _FinalStage name(String name);

            /**
             * <p>The custom attributes which are set for the visitor.</p>
             */
            _FinalStage customAttributes(Optional<Map<String, String>> customAttributes);

            _FinalStage customAttributes(Map<String, String> customAttributes);
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder implements UserIdStage, _FinalStage {
            private String userId;

            private Optional<Map<String, String>> customAttributes = Optional.empty();

            private Optional<String> name = Optional.empty();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            @java.lang.Override
            public Builder from(WithUserId other) {
                userId(other.getUserId());
                name(other.getName());
                customAttributes(other.getCustomAttributes());
                return this;
            }

            /**
             * <p>A unique identified for the visitor which is given by you.</p>
             * <p>A unique identified for the visitor which is given by you.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("user_id")
            public _FinalStage userId(@NotNull String userId) {
                this.userId = Objects.requireNonNull(userId, "userId must not be null");
                return this;
            }

            /**
             * <p>The custom attributes which are set for the visitor.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            public _FinalStage customAttributes(Map<String, String> customAttributes) {
                this.customAttributes = Optional.ofNullable(customAttributes);
                return this;
            }

            /**
             * <p>The custom attributes which are set for the visitor.</p>
             */
            @java.lang.Override
            @JsonSetter(value = "custom_attributes", nulls = Nulls.SKIP)
            public _FinalStage customAttributes(Optional<Map<String, String>> customAttributes) {
                this.customAttributes = customAttributes;
                return this;
            }

            /**
             * <p>The visitor's name.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            public _FinalStage name(String name) {
                this.name = Optional.ofNullable(name);
                return this;
            }

            /**
             * <p>The visitor's name.</p>
             */
            @java.lang.Override
            @JsonSetter(value = "name", nulls = Nulls.SKIP)
            public _FinalStage name(Optional<String> name) {
                this.name = name;
                return this;
            }

            @java.lang.Override
            public WithUserId build() {
                return new WithUserId(userId, name, customAttributes, additionalProperties);
            }
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = WithId.Builder.class)
    public static final class WithId {
        private final String id;

        private final Optional<String> name;

        private final Optional<Map<String, String>> customAttributes;

        private final Map<String, Object> additionalProperties;

        private WithId(
                String id,
                Optional<String> name,
                Optional<Map<String, String>> customAttributes,
                Map<String, Object> additionalProperties) {
            this.id = id;
            this.name = name;
            this.customAttributes = customAttributes;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return A unique identified for the visitor which is given by Intercom.
         */
        @JsonProperty("id")
        public String getId() {
            return id;
        }

        /**
         * @return The visitor's name.
         */
        @JsonProperty("name")
        public Optional<String> getName() {
            return name;
        }

        /**
         * @return The custom attributes which are set for the visitor.
         */
        @JsonProperty("custom_attributes")
        public Optional<Map<String, String>> getCustomAttributes() {
            return customAttributes;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof WithId && equalTo((WithId) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(WithId other) {
            return id.equals(other.id) && name.equals(other.name) && customAttributes.equals(other.customAttributes);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.id, this.name, this.customAttributes);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static IdStage builder() {
            return new Builder();
        }

        public interface IdStage {
            /**
             * <p>A unique identified for the visitor which is given by Intercom.</p>
             */
            _FinalStage id(@NotNull String id);

            Builder from(WithId other);
        }

        public interface _FinalStage {
            WithId build();

            /**
             * <p>The visitor's name.</p>
             */
            _FinalStage name(Optional<String> name);

            _FinalStage name(String name);

            /**
             * <p>The custom attributes which are set for the visitor.</p>
             */
            _FinalStage customAttributes(Optional<Map<String, String>> customAttributes);

            _FinalStage customAttributes(Map<String, String> customAttributes);
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder implements IdStage, _FinalStage {
            private String id;

            private Optional<Map<String, String>> customAttributes = Optional.empty();

            private Optional<String> name = Optional.empty();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            @java.lang.Override
            public Builder from(WithId other) {
                id(other.getId());
                name(other.getName());
                customAttributes(other.getCustomAttributes());
                return this;
            }

            /**
             * <p>A unique identified for the visitor which is given by Intercom.</p>
             * <p>A unique identified for the visitor which is given by Intercom.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("id")
            public _FinalStage id(@NotNull String id) {
                this.id = Objects.requireNonNull(id, "id must not be null");
                return this;
            }

            /**
             * <p>The custom attributes which are set for the visitor.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            public _FinalStage customAttributes(Map<String, String> customAttributes) {
                this.customAttributes = Optional.ofNullable(customAttributes);
                return this;
            }

            /**
             * <p>The custom attributes which are set for the visitor.</p>
             */
            @java.lang.Override
            @JsonSetter(value = "custom_attributes", nulls = Nulls.SKIP)
            public _FinalStage customAttributes(Optional<Map<String, String>> customAttributes) {
                this.customAttributes = customAttributes;
                return this;
            }

            /**
             * <p>The visitor's name.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            public _FinalStage name(String name) {
                this.name = Optional.ofNullable(name);
                return this;
            }

            /**
             * <p>The visitor's name.</p>
             */
            @java.lang.Override
            @JsonSetter(value = "name", nulls = Nulls.SKIP)
            public _FinalStage name(Optional<String> name) {
                this.name = name;
                return this;
            }

            @java.lang.Override
            public WithId build() {
                return new WithId(id, name, customAttributes, additionalProperties);
            }
        }
    }
}
