/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.openapi;

import io.jooby.Router;
import io.jooby.SneakyThrows;
import io.jooby.internal.openapi.ClassSource;
import io.jooby.internal.openapi.ContextPathParser;
import io.jooby.internal.openapi.OpenAPIExt;
import io.jooby.internal.openapi.OpenAPIParser;
import io.jooby.internal.openapi.OperationExt;
import io.jooby.internal.openapi.ParserContext;
import io.jooby.internal.openapi.RouteParser;
import io.jooby.internal.openapi.TypeFactory;
import io.jooby.openapi.DebugOption;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.tags.Tag;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAPIGenerator {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private Set<DebugOption> debug;
    private ClassLoader classLoader;
    private Path basedir;
    private Path outputDir = this.basedir = java.nio.file.Paths.get(System.getProperty("user.dir"), new String[0]);
    private String templateName = "openapi.yaml";
    private String includes;
    private String excludes;

    @Nonnull
    public Path export(@Nonnull OpenAPI openAPI, @Nonnull Format format) throws IOException {
        Path output;
        if (openAPI instanceof OpenAPIExt) {
            String source = ((OpenAPIExt)openAPI).getSource();
            String[] names = source.split("\\.");
            output = Stream.of(names).limit(names.length - 1).reduce(this.outputDir, Path::resolve, Path::resolve);
            String appname = names[names.length - 1];
            if (appname.endsWith("Kt")) {
                appname = appname.substring(0, appname.length() - 2);
            }
            output = output.resolve(appname + "." + format.extension());
        } else {
            output = this.outputDir.resolve("openapi." + format.extension());
        }
        if (!Files.exists(output.getParent(), new LinkOption[0])) {
            Files.createDirectories(output.getParent(), new FileAttribute[0]);
        }
        String content = format.toString(this, openAPI);
        Files.write(output, Collections.singleton(content), new OpenOption[0]);
        return output;
    }

    @Nonnull
    public OpenAPI generate(@Nonnull String classname) {
        ClassLoader classLoader = Optional.ofNullable(this.classLoader).orElseGet(this.getClass()::getClassLoader);
        ClassSource source = new ClassSource(classLoader);
        RouteParser routes = new RouteParser();
        ParserContext ctx = new ParserContext(source, TypeFactory.fromJavaName(classname), this.debug);
        List<OperationExt> operations = routes.parse(ctx);
        String contextPath = ContextPathParser.parse(ctx);
        OpenAPIExt openapi = new OpenAPIExt();
        openapi.setSource(Optional.ofNullable(ctx.getMainClass()).orElse(classname));
        OpenAPIParser.parse(ctx, openapi);
        OpenAPIExt.fromTemplate(this.basedir, classLoader, this.templateName).ifPresent(template -> this.merge(openapi, (OpenAPI)template));
        this.defaults(classname, contextPath, openapi);
        ctx.schemas().forEach(schema -> openapi.schema(schema.getName(), (Schema)schema));
        LinkedHashMap globalTags = new LinkedHashMap();
        Paths paths = new Paths();
        for (OperationExt operation : operations) {
            String pattern = operation.getPattern();
            if (!this.includes(pattern) || this.excludes(pattern)) {
                this.log.debug("skipping {}", (Object)pattern);
                continue;
            }
            HashMap regexMap = new HashMap();
            Router.pathKeys((String)pattern, (key, value) -> Optional.ofNullable(value).ifPresent(v -> regexMap.put(key, v)));
            if (regexMap.size() > 0) {
                for (Map.Entry e : regexMap.entrySet()) {
                    String name = (String)e.getKey();
                    String regex = (String)e.getValue();
                    operation.getParameter(name).ifPresent(parameter -> parameter.getSchema().setPattern(regex));
                    if (regex.equals("\\.*")) {
                        if (name.equals("*")) {
                            pattern = pattern.substring(0, pattern.length() - 1) + "{*}";
                            continue;
                        }
                        pattern = pattern.replace("*" + name, "{" + name + "}");
                        continue;
                    }
                    pattern = pattern.replace(name + ":" + regex, name);
                }
            }
            PathItem pathItem = (PathItem)paths.computeIfAbsent((Object)pattern, k -> new PathItem());
            pathItem.operation(PathItem.HttpMethod.valueOf((String)operation.getMethod()), (Operation)operation);
            Optional.ofNullable(operation.getPathSummary()).ifPresent(arg_0 -> ((PathItem)pathItem).setSummary(arg_0));
            Optional.ofNullable(operation.getPathDescription()).ifPresent(arg_0 -> ((PathItem)pathItem).setDescription(arg_0));
            operation.getGlobalTags().forEach(tag -> globalTags.put(tag.getName(), tag));
        }
        globalTags.values().forEach(tag -> {
            if (tag.getDescription() != null || tag.getExtensions() != null) {
                openapi.addTagsItem((Tag)tag);
            }
        });
        openapi.setOperations(operations);
        openapi.setPaths(paths);
        return openapi;
    }

    private void merge(OpenAPIExt openapi, OpenAPI template) {
        try {
            openapi.setComponents(Optional.ofNullable(openapi.getComponents()).orElseGet(() -> ((OpenAPI)template).getComponents()));
            openapi.setSecurity(Optional.ofNullable(openapi.getSecurity()).orElseGet(() -> ((OpenAPI)template).getSecurity()));
            openapi.setServers(Optional.ofNullable(openapi.getServers()).orElseGet(() -> ((OpenAPI)template).getServers()));
            openapi.setInfo(Optional.ofNullable(openapi.getInfo()).orElseGet(() -> ((OpenAPI)template).getInfo()));
            openapi.setExternalDocs(Optional.ofNullable(openapi.getExternalDocs()).orElseGet(() -> ((OpenAPI)template).getExternalDocs()));
            openapi.setTags(Optional.ofNullable(openapi.getTags()).orElseGet(() -> ((OpenAPI)template).getTags()));
            openapi.setExtensions(Optional.ofNullable(openapi.getExtensions()).orElseGet(() -> ((OpenAPI)template).getExtensions()));
        }
        catch (Exception x) {
            throw SneakyThrows.propagate((Throwable)x);
        }
    }

    private boolean includes(String value) {
        return this.pattern(this.includes, value).orElse(true);
    }

    private boolean excludes(String value) {
        return this.pattern(this.excludes, value).orElse(false);
    }

    private Optional<Boolean> pattern(String pattern, String value) {
        return Optional.ofNullable(pattern).map(regex -> Pattern.matches(regex, value));
    }

    private void defaults(String classname, String contextPath, OpenAPIExt openapi) {
        Info info = openapi.getInfo();
        if (info == null) {
            info = new Info();
            openapi.info(info);
        }
        String appname = this.appname(classname);
        info.setTitle(Optional.ofNullable(info.getTitle()).orElse(appname + " API"));
        info.setDescription(Optional.ofNullable(info.getDescription()).orElse(appname + " API description"));
        info.setVersion(Optional.ofNullable(info.getVersion()).orElse("1.0"));
        if ((openapi.getServers() == null || openapi.getServers().isEmpty()) && !contextPath.equals("/")) {
            Server server = new Server();
            server.setUrl(contextPath);
            openapi.setServers(Collections.singletonList(server));
        }
    }

    @Nonnull
    public String toYaml(@Nonnull OpenAPI openAPI) {
        try {
            return Yaml.mapper().writeValueAsString((Object)openAPI);
        }
        catch (IOException x) {
            throw SneakyThrows.propagate((Throwable)x);
        }
    }

    @Nonnull
    public String toJson(@Nonnull OpenAPI openAPI) {
        try {
            return Json.mapper().writer().withDefaultPrettyPrinter().writeValueAsString((Object)openAPI);
        }
        catch (IOException x) {
            throw SneakyThrows.propagate((Throwable)x);
        }
    }

    public void setClassLoader(@Nonnull ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setDebug(Set<DebugOption> debug) {
        this.debug = debug;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(@Nonnull String templateName) {
        this.templateName = templateName;
    }

    public void setBasedir(@Nonnull Path basedir) {
        this.basedir = basedir;
    }

    public Path getBasedir() {
        return this.basedir;
    }

    public Path getOutputDir() {
        return this.outputDir;
    }

    @Nullable
    public String getIncludes() {
        return this.includes;
    }

    public void setIncludes(@Nullable String includes) {
        this.includes = includes;
    }

    @Nullable
    public String getExcludes() {
        return this.excludes;
    }

    public void setExcludes(@Nullable String excludes) {
        this.excludes = excludes;
    }

    public void setOutputDir(@Nonnull Path outputDir) {
        this.outputDir = outputDir;
    }

    private String appname(String classname) {
        String name = classname;
        int i = name.lastIndexOf(46);
        if (i > 0) {
            name = name.substring(i + 1);
            name = name.replace("App", "").replace("Kt", "").trim();
        }
        return name.length() == 0 ? "My App" : name;
    }

    public static enum Format {
        JSON{

            @Override
            public String toString(OpenAPIGenerator tool, OpenAPI result) {
                return tool.toJson(result);
            }
        }
        ,
        YAML{

            @Override
            public String toString(OpenAPIGenerator tool, OpenAPI result) {
                return tool.toYaml(result);
            }
        };


        @Nonnull
        public String extension() {
            return this.name().toLowerCase();
        }

        @Nonnull
        public abstract String toString(@Nonnull OpenAPIGenerator var1, @Nonnull OpenAPI var2);
    }
}

