/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.openapi;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum MergePolicy {
    FAIL{

        @Override
        public boolean handle(String message) {
            throw new IllegalArgumentException(message);
        }
    }
    ,
    KEEP{

        @Override
        public boolean handle(String message) {
            return true;
        }
    }
    ,
    IGNORE{

        @Override
        public boolean handle(String message) {
            return false;
        }
    };


    public static MergePolicy parse(Map<String, Object> extensions, MergePolicy defaultPolicy) {
        if (extensions == null) {
            return defaultPolicy;
        }
        Object value = extensions.remove("x-merge-policy");
        return Optional.ofNullable(value).map(Objects::toString).map(String::toUpperCase).map(MergePolicy::valueOf).orElse(defaultPolicy);
    }

    public abstract boolean handle(String var1);
}

