/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.noteblocklib.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import net.raphimc.noteblocklib.model.Note;
import net.raphimc.noteblocklib.model.NoteWithVolume;
import net.raphimc.noteblocklib.model.SongView;

public class SongUtil {
    public static <N extends Note> void applyToAllNotes(SongView<N> songView, Consumer<N> noteConsumer) {
        songView.getNotes().values().stream().flatMap(Collection::stream).forEach(noteConsumer);
    }

    public static <N extends Note> void removeDoubleNotes(SongView<N> songView) {
        for (List<N> list : songView.getNotes().values()) {
            HashSet<N> set = new HashSet<N>(list);
            list.clear();
            list.addAll(set);
        }
    }

    public static <N extends Note> void removeSilentNotes(SongView<N> songView) {
        SongUtil.removeSilentNotes(songView, 0.0f);
    }

    public static <N extends Note> void removeSilentNotes(SongView<N> songView, float threshold) {
        for (List<N> list : songView.getNotes().values()) {
            list.removeIf(note -> {
                if (note instanceof NoteWithVolume) {
                    return ((NoteWithVolume)((Object)note)).getVolume() <= threshold;
                }
                return false;
            });
        }
    }
}

