/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.noteblocklib.format.nbs.model;

import com.google.common.io.LittleEndianDataInputStream;
import com.google.common.io.LittleEndianDataOutputStream;
import java.io.IOException;
import java.util.Objects;
import net.raphimc.noteblocklib.format.nbs.model.NbsHeader;
import net.raphimc.noteblocklib.format.nbs.model.NbsLayer;
import net.raphimc.noteblocklib.model.Note;
import net.raphimc.noteblocklib.model.NoteWithPanning;
import net.raphimc.noteblocklib.model.NoteWithVolume;

public class NbsNote
extends Note
implements NoteWithVolume,
NoteWithPanning {
    private NbsLayer layer;
    private byte velocity = (byte)100;
    private short panning = (short)100;
    private short pitch = 0;

    public NbsNote(NbsHeader header, NbsLayer layer, LittleEndianDataInputStream dis) throws IOException {
        super(dis.readByte(), dis.readByte());
        if (header.getVersion() >= 4) {
            this.velocity = dis.readByte();
            this.panning = (short)dis.readUnsignedByte();
            this.pitch = dis.readShort();
        }
        this.layer = layer;
    }

    public NbsNote(NbsLayer layer, byte instrument, byte key, byte velocity, short panning, short pitch) {
        super(instrument, key);
        this.layer = layer;
        this.velocity = velocity;
        this.panning = panning;
        this.pitch = pitch;
    }

    public NbsNote(NbsLayer layer, byte instrument, byte key) {
        super(instrument, key);
        this.layer = layer;
    }

    public NbsNote(byte instrument, byte key) {
        super(instrument, key);
    }

    public void write(NbsHeader header, LittleEndianDataOutputStream dos) throws IOException {
        dos.writeByte((int)this.instrument);
        dos.writeByte((int)this.key);
        if (header.getVersion() >= 4) {
            dos.writeByte((int)this.velocity);
            dos.writeByte((int)this.panning);
            dos.writeShort((int)this.pitch);
        }
    }

    public NbsLayer getLayer() {
        return this.layer;
    }

    public void setLayer(NbsLayer layer) {
        this.layer = layer;
    }

    @Override
    public float getVolume() {
        float layerVolume = this.layer != null ? (float)this.layer.getVolume() : 100.0f;
        float noteVolume = this.velocity;
        return layerVolume * noteVolume / 100.0f;
    }

    @Override
    public void setVolume(float volume) {
        this.velocity = (byte)volume;
    }

    public byte getRawVelocity() {
        return this.velocity;
    }

    @Override
    public float getPanning() {
        float layerPanning = this.layer != null ? (float)(this.layer.getPanning() - 100) : 0.0f;
        float notePanning = this.panning - 100;
        return (layerPanning + notePanning) / 2.0f;
    }

    @Override
    public void setPanning(float panning) {
        this.panning = (short)(panning + 100.0f);
    }

    public short getRawPanning() {
        return this.panning;
    }

    public short getPitch() {
        return this.pitch;
    }

    public void setPitch(short pitch) {
        this.pitch = pitch;
    }

    @Override
    public NbsNote clone() {
        return new NbsNote(this.layer, this.instrument, this.key, this.velocity, this.panning, this.pitch);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NbsNote nbsNote = (NbsNote)o;
        return this.velocity == nbsNote.velocity && this.panning == nbsNote.panning && this.pitch == nbsNote.pitch;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.velocity, this.panning, this.pitch);
    }
}

