/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.noteblocklib.util;

public enum Instrument {
    HARP(0, 0, 0),
    BASS(1, 4, 4),
    BASS_DRUM(2, 1, 1),
    SNARE(3, 2, 2),
    HAT(4, 3, 3),
    GUITAR(5, 7, 8),
    FLUTE(6, 5, 6),
    BELL(7, 6, 5),
    CHIME(8, 8, 7),
    XYLOPHONE(9, 9, 9),
    IRON_XYLOPHONE(10, 10, 10),
    COW_BELL(11, 11, 11),
    DIDGERIDOO(12, 12, 12),
    BIT(13, 13, 13),
    BANJO(14, 14, 14),
    PLING(15, 15, 15);

    private final byte nbsId;
    private final byte mcId;
    private final byte mcbeId;

    private Instrument(int nbsId, int mcId, int mcbeId) {
        this.nbsId = (byte)nbsId;
        this.mcId = (byte)mcId;
        this.mcbeId = (byte)mcbeId;
    }

    public byte nbsId() {
        return this.nbsId;
    }

    public byte mcId() {
        return this.mcId;
    }

    public byte mcbeId() {
        return this.mcbeId;
    }

    public static Instrument fromNbsId(byte nbsId) {
        for (Instrument instrument : Instrument.values()) {
            if (instrument.nbsId != nbsId) continue;
            return instrument;
        }
        return null;
    }

    public static Instrument fromMcId(byte mcId) {
        for (Instrument instrument : Instrument.values()) {
            if (instrument.mcId != mcId) continue;
            return instrument;
        }
        return null;
    }

    public static Instrument fromMcbeId(byte mcbeId) {
        for (Instrument instrument : Instrument.values()) {
            if (instrument.mcbeId != mcbeId) continue;
            return instrument;
        }
        return null;
    }
}

