/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.noteblocklib.util;

import java.util.HashMap;
import java.util.Map;
import net.raphimc.noteblocklib.model.Note;
import net.raphimc.noteblocklib.util.Instrument;

public class MinecraftDefinitions {
    public static final int MC_LOWEST_KEY = 33;
    public static final int MC_HIGHEST_KEY = 57;
    public static final int MC_KEYS = 24;
    private static final Map<Instrument, Instrument[][]> INSTRUMENT_SHIFTS = new HashMap<Instrument, Instrument[][]>();

    public static float mcKeyToMcPitch(int mcKey) {
        return (float)Math.pow(2.0, (double)(mcKey - 12) / 12.0);
    }

    public static int mcPitchToMcKey(float mcPitch) {
        return (int)Math.round(Math.log(mcPitch) / Math.log(2.0) * 12.0 + 12.0);
    }

    public static float nbsPitchToMcPitch(int nbsPitch) {
        return (float)Math.pow(2.0, ((float)nbsPitch / 100.0f - 33.0f - 12.0f) / 12.0f);
    }

    public static int nbsKeyToMcKey(int nbsKey) {
        return nbsKey - 33;
    }

    public static int mcKeyToNbsKey(int mcKey) {
        return mcKey + 33;
    }

    public static boolean isOutsideOctaveRange(int nbsKey) {
        return nbsKey < 33 || nbsKey > 57;
    }

    public static void clampNoteKey(Note note) {
        note.setKey((byte)Math.max(33, Math.min(57, note.getKey())));
    }

    public static void transposeNoteKey(Note note) {
        MinecraftDefinitions.transposeNoteKey(note, 12);
    }

    public static void transposeNoteKey(Note note, int transposeAmount) {
        byte nbsKey = note.getKey();
        while (nbsKey < 33) {
            nbsKey = (byte)(nbsKey + transposeAmount);
        }
        while (nbsKey > 57) {
            nbsKey = (byte)(nbsKey - transposeAmount);
        }
        note.setKey(nbsKey);
    }

    public static void instrumentShiftNote(Note note) {
        byte nbsKey;
        Instrument instrument = Instrument.fromNbsId(note.getInstrument());
        if (instrument == null) {
            return;
        }
        Instrument[][] shifts = INSTRUMENT_SHIFTS.get((Object)instrument);
        if (shifts == null) {
            return;
        }
        int downShifts = 0;
        for (nbsKey = note.getKey(); nbsKey < 33 && downShifts < shifts[0].length; nbsKey = (byte)(nbsKey + 24)) {
            instrument = shifts[0][downShifts++];
        }
        int upShifts = 0;
        while (nbsKey > 57 && upShifts < shifts[1].length) {
            instrument = shifts[1][upShifts++];
            nbsKey = (byte)(nbsKey - 24);
        }
        note.setInstrument(instrument.nbsId());
        note.setKey(nbsKey);
    }

    static {
        INSTRUMENT_SHIFTS.put(Instrument.HARP, new Instrument[][]{{Instrument.BASS}, {Instrument.BELL}});
        INSTRUMENT_SHIFTS.put(Instrument.BASS, new Instrument[][]{new Instrument[0], {Instrument.HARP, Instrument.BELL}});
        INSTRUMENT_SHIFTS.put(Instrument.BASS_DRUM, new Instrument[][]{new Instrument[0], {Instrument.SNARE}});
        INSTRUMENT_SHIFTS.put(Instrument.SNARE, new Instrument[][]{{Instrument.BASS_DRUM}, {Instrument.HAT}});
        INSTRUMENT_SHIFTS.put(Instrument.HAT, new Instrument[][]{{Instrument.BASS_DRUM}, {Instrument.CHIME}});
        INSTRUMENT_SHIFTS.put(Instrument.GUITAR, new Instrument[][]{{Instrument.BASS}, {Instrument.COW_BELL, Instrument.XYLOPHONE}});
        INSTRUMENT_SHIFTS.put(Instrument.FLUTE, new Instrument[][]{{Instrument.DIDGERIDOO}, {Instrument.BELL, Instrument.CHIME}});
        INSTRUMENT_SHIFTS.put(Instrument.BELL, new Instrument[][]{{Instrument.HARP}, new Instrument[0]});
        INSTRUMENT_SHIFTS.put(Instrument.CHIME, new Instrument[][]{{Instrument.BELL}, new Instrument[0]});
        INSTRUMENT_SHIFTS.put(Instrument.XYLOPHONE, new Instrument[][]{{Instrument.COW_BELL}, {Instrument.CHIME}});
        INSTRUMENT_SHIFTS.put(Instrument.IRON_XYLOPHONE, new Instrument[][]{{Instrument.BASS}, {Instrument.BELL}});
        INSTRUMENT_SHIFTS.put(Instrument.COW_BELL, new Instrument[][]{{Instrument.GUITAR}, {Instrument.XYLOPHONE}});
        INSTRUMENT_SHIFTS.put(Instrument.DIDGERIDOO, new Instrument[][]{{Instrument.BASS}, {Instrument.FLUTE, Instrument.BELL}});
        INSTRUMENT_SHIFTS.put(Instrument.BIT, new Instrument[][]{{Instrument.DIDGERIDOO}, {Instrument.BELL}});
        INSTRUMENT_SHIFTS.put(Instrument.BANJO, new Instrument[][]{{Instrument.DIDGERIDOO}, {Instrument.BELL}});
        INSTRUMENT_SHIFTS.put(Instrument.PLING, new Instrument[][]{{Instrument.BASS}, {Instrument.BELL}});
    }
}

