/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.noteblocklib.format.nbs.model;

import com.google.common.io.LittleEndianDataInputStream;
import com.google.common.io.LittleEndianDataOutputStream;
import java.io.IOException;
import java.util.Objects;
import net.raphimc.noteblocklib.format.nbs.NbsParser;

public class NbsCustomInstrument {
    private String name;
    private String soundFileName;
    private byte pitch;
    private boolean pressKey;

    public NbsCustomInstrument(LittleEndianDataInputStream dis) throws IOException {
        this.name = NbsParser.readString(dis);
        this.soundFileName = NbsParser.readString(dis);
        this.pitch = dis.readByte();
        this.pressKey = dis.readBoolean();
    }

    public NbsCustomInstrument(String name, String soundFileName, byte pitch, boolean pressKey) {
        this.name = name;
        this.soundFileName = soundFileName;
        this.pitch = pitch;
        this.pressKey = pressKey;
    }

    public void write(LittleEndianDataOutputStream dos) throws IOException {
        NbsParser.writeString(dos, this.name);
        NbsParser.writeString(dos, this.soundFileName);
        dos.writeByte((int)this.pitch);
        dos.writeBoolean(this.pressKey);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSoundFileName() {
        return this.soundFileName;
    }

    public void setSoundFileName(String soundFileName) {
        this.soundFileName = soundFileName;
    }

    public byte getPitch() {
        return this.pitch;
    }

    public void setPitch(byte pitch) {
        this.pitch = pitch;
    }

    public boolean isPressKey() {
        return this.pressKey;
    }

    public void setPressKey(boolean pressKey) {
        this.pressKey = pressKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NbsCustomInstrument that = (NbsCustomInstrument)o;
        return this.pitch == that.pitch && this.pressKey == that.pressKey && Objects.equals(this.name, that.name) && Objects.equals(this.soundFileName, that.soundFileName);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.soundFileName, this.pitch, this.pressKey);
    }
}

