/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.noteblocklib.player;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.raphimc.noteblocklib.model.SongView;
import net.raphimc.noteblocklib.player.SongPlayerCallback;

public class SongPlayer {
    private static final ScheduledExecutorService SCHEDULER = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("Song Player").setDaemon(true).build());
    private final SongView<?> songView;
    private final SongPlayerCallback callback;
    private ScheduledFuture<?> timer;
    private int tick = -1;
    private boolean paused;

    public SongPlayer(SongView<?> songView, SongPlayerCallback callback) {
        this.songView = songView;
        this.callback = callback;
    }

    public SongView<?> getSongView() {
        return this.songView;
    }

    public boolean isRunning() {
        return this.timer != null && !this.timer.isDone() && !this.timer.isCancelled();
    }

    public int getTick() {
        return this.tick;
    }

    public void setTick(int tick) {
        this.tick = tick;
    }

    public void play() {
        this.paused = false;
        if (this.isRunning()) {
            this.stop();
        }
        this.timer = SCHEDULER.scheduleAtFixedRate(this::tick, 0L, (long)(1.0E9 / (double)this.songView.getSpeed()), TimeUnit.NANOSECONDS);
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void stop() {
        if (!this.isRunning()) {
            return;
        }
        this.timer.cancel(true);
        this.paused = false;
    }

    private void tick() {
        try {
            if (this.paused || !this.callback.shouldTick()) {
                return;
            }
            ++this.tick;
            if (this.tick > this.songView.getLength()) {
                if (this.callback.shouldLoop()) {
                    this.tick = -this.callback.getLoopDelay();
                } else {
                    this.callback.onFinished();
                    this.tick = -1;
                    this.stop();
                }
                return;
            }
            this.callback.playNotes(this.songView.getNotesAtTick(this.tick));
        }
        catch (Throwable e) {
            if (e.getCause() instanceof InterruptedException) {
                return;
            }
            e.printStackTrace();
            this.stop();
        }
    }
}

