/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.noteblocklib.format.mcsp.model;

import java.util.NoSuchElementException;
import java.util.Scanner;
import net.raphimc.noteblocklib.model.Header;

public class McSpHeader
implements Header {
    private int version;
    private String title = "";
    private String author = "";
    private String originalAuthor = "";
    private int speed = 10;
    private int autoSaveInterval;
    private int leftClicks;
    private int rightClicks;
    private int noteBlocksAdded;
    private int noteBlocksRemoved;
    private int minutesSpent;

    public McSpHeader(Scanner scanner) {
        scanner.useDelimiter("\\|");
        this.version = scanner.nextInt();
        if (this.version != 0 && this.version != 2) {
            throw new IllegalStateException("Unsupported MCSP version: " + this.version);
        }
        if (this.version == 2) {
            this.autoSaveInterval = scanner.nextInt();
            this.title = scanner.next();
            this.author = scanner.next();
            this.originalAuthor = scanner.next();
            if (!scanner.next().isEmpty()) {
                throw new IllegalStateException("Invalid MCSP header");
            }
            try {
                scanner.nextLine();
                this.speed = scanner.nextInt();
                this.leftClicks = scanner.nextInt();
                this.rightClicks = scanner.nextInt();
                this.noteBlocksAdded = scanner.nextInt();
                this.noteBlocksRemoved = scanner.nextInt();
                this.minutesSpent = scanner.nextInt();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
    }

    public McSpHeader(int version) {
        this.version = version;
    }

    public McSpHeader(int version, int autoSaveInterval, String title, String author, String originalAuthor, int speed, int leftClicks, int rightClicks, int noteBlocksAdded, int noteBlocksRemoved, int minutesSpent) {
        this.version = version;
        this.autoSaveInterval = autoSaveInterval;
        this.title = title;
        this.author = author;
        this.originalAuthor = originalAuthor;
        this.speed = speed;
        this.leftClicks = leftClicks;
        this.rightClicks = rightClicks;
        this.noteBlocksAdded = noteBlocksAdded;
        this.noteBlocksRemoved = noteBlocksRemoved;
        this.minutesSpent = minutesSpent;
    }

    public McSpHeader() {
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getOriginalAuthor() {
        return this.originalAuthor;
    }

    public void setOriginalAuthor(String originalAuthor) {
        this.originalAuthor = originalAuthor;
    }

    public int getSpeed() {
        return this.speed;
    }

    public void setSpeed(int speed) {
        this.speed = speed;
    }

    public int getAutoSaveInterval() {
        return this.autoSaveInterval;
    }

    public void setAutoSaveInterval(int autoSaveInterval) {
        this.autoSaveInterval = autoSaveInterval;
    }

    public int getLeftClicks() {
        return this.leftClicks;
    }

    public void setLeftClicks(int leftClicks) {
        this.leftClicks = leftClicks;
    }

    public int getRightClicks() {
        return this.rightClicks;
    }

    public void setRightClicks(int rightClicks) {
        this.rightClicks = rightClicks;
    }

    public int getNoteBlocksAdded() {
        return this.noteBlocksAdded;
    }

    public void setNoteBlocksAdded(int noteBlocksAdded) {
        this.noteBlocksAdded = noteBlocksAdded;
    }

    public int getNoteBlocksRemoved() {
        return this.noteBlocksRemoved;
    }

    public void setNoteBlocksRemoved(int noteBlocksRemoved) {
        this.noteBlocksRemoved = noteBlocksRemoved;
    }

    public int getMinutesSpent() {
        return this.minutesSpent;
    }

    public void setMinutesSpent(int minutesSpent) {
        this.minutesSpent = minutesSpent;
    }
}

