/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.api.roboguice;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class RoboGuiceHelper {
    private RoboGuiceHelper() {
    }

    public static void callInjectViews(Object activity) {
        try {
            Class<?> viewMembersInjectorClass = Class.forName("roboguice.inject.ViewListener$ViewMembersInjector");
            Method injectViewsMethod = viewMembersInjectorClass.getDeclaredMethod("injectViews", Object.class);
            injectViewsMethod.setAccessible(true);
            injectViewsMethod.invoke(null, activity);
        }
        catch (ClassNotFoundException e) {
            RoboGuiceHelper.propagateRuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            RoboGuiceHelper.propagateRuntimeException(e);
        }
        catch (SecurityException e) {
            RoboGuiceHelper.propagateRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            RoboGuiceHelper.propagateRuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            RoboGuiceHelper.propagateRuntimeException(e);
        }
        catch (InvocationTargetException e) {
            RoboGuiceHelper.propagateRuntimeException(e);
        }
    }

    private static void propagateRuntimeException(Throwable t) {
        throw new RuntimeException("Could not invoke RoboGuice method!", t);
    }
}

